//
// Clear class for PTC 2.0 C++ API (HERMES INTERFACE PACKAGE)
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_CLEAR_H
#define __PTC_CLEAR_H

// include files
#include "Index.h"
#include "Hermes.h"




class Clear
{
    public:

        // setup
        Clear();
        ~Clear();

        // request clear
        void request(const Format &format);
        
        // clear pixels
        void clear(void *pixels,int x,int y,int width,int height,int pitch,const Color &color);

    private:

        // disallow copy construction
	    Clear(const Clear &clear);
	    
        // disallow assignment
        Clear& operator =(const Clear &clear);

        // hermes clear handle
    	HermesHandle m_handle;

        // current format
    	Format *m_format;
};




#endif
