//
// Keyboard example
// Copyright (c) Robbin Bonthond (elemental@chaos.concepts.nl)
// This source code is licensed under the GNU GPL
//

#include "ptc.h"

void main(void)
{
  try {
    Format format(32,0xff0000,0xff00,0xff);
    Console console;
    console.open( "keyboard test", 320,200,format );

    Surface surface(320,200,format);

    int x=160,y=100;

    while( !console.isKeyPressed(Key::ESCAPE) ) {

      if( console.isKeyPressed(Key::LEFT) )
        x--;
      if( console.isKeyPressed(Key::RIGHT) )
        x++;
      if( console.isKeyPressed(Key::UP) )
        y--;
      if( console.isKeyPressed(Key::DOWN) )
        y++;

      if( x > 0 && y > 0 && x < 319 && y < 199 ) {
        int32 *screen = (int32*)surface.lock();
        screen[y*320+x] = (255<<16)|(255<<8)|255;
        surface.unlock();
      }

      surface.copy( console );
      console.update();
    }

    // flush keyboard
    while( console.key() )
      console.read();

  }

  // report errors if there are any
  catch( Error &error ) {
    error.report();
  }

}

