/*
 * Compiler settings for OpenPTC 1.0 C++ Implementation
 * Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
 * This source code is licensed under the GNU LGPL
 * See http://www.gnu.org/copyleft/lgpl.html for details
 */

#ifndef __PTC_COMPILER_H
#define __PTC_CONPILER_H




#if (_MSC_VER>=1100)


    /* Visual C++ 5.0 and greater */

    /* compiler has boolean type support */
    #define __COMPILER_SUPPORTS_BOOL__

    /* compiler has const_cast support */
    #define __COMPILER_SUPPORTS_CONST_CAST__

    /* compiler has namespace support */
    #define __COMPILER_SUPPORTS_NAMESPACES__

    /* compiler supports ddraw */
    #define __COMPILER_SUPPORTS_DDRAW__

    /* ptc api convention */
    #define PTCAPI __stdcall

    /* callback convention */
    #define PTC_CALLBACK _cdecl


#elif (__WATCOMC__>=1100)


    /* Watcom C++ 11.0 and greater

    /* compiler has boolean type support */
    #define __COMPILER_SUPPORTS_BOOL__

    /* compiler supports ddraw */
    #define __COMPILER_SUPPORTS_DDRAW__


#elif (__WATCOMC__>=900)


    /* Watcom C++ 10.0, 10.5 and 10.6 */


#elif defined (__CYGWIN32__)


    /*  Cygnus GNU-Win32 (Cygwin) */

    /* compiler has boolean type support */
    #define __COMPILER_SUPPORTS_BOOL__


#else


    /* Unknown Compiler */

    /* define this if the compiler has boolean type support */
    #define __COMPILER_SUPPORTS_BOOL__

    /* define this if the compiler has const_cast support */
    #define __COMPILER_SUPPORTS_CONST_CAST__

    /* define this if the compiler has namespace support */
    #define __COMPILER_SUPPORTS_NAMESPACES__


#endif




/* check compiler bool type support */
#ifndef __COMPILER_SUPPORTS_BOOL__

    /* emulate 'bool' */
    typedef int bool;
    #define true 1
    #define false 0

#endif


/* check compiler ddraw support */
#ifndef __COMPILER_SUPPORTS_DDRAW__

    /* emulate ddraw types */
    #define LPDIRECTDRAW void*
    #define LPDIRECTDRAW2 void*
    #define LPDIRECTDRAWSURFACE void*

#endif

        


/* ptc api convention */
#ifndef PTCAPI
#include <windows.h>
#define PTCAPI WINAPI
#endif


/* c api convention */
#ifdef __cplusplus
#define CAPI extern "C"
#else
#define CAPI
#endif

        
/* callback convention */
#ifndef PTC_CALLBACK
#define PTC_CALLBACK
#endif


/* debug build */
#ifndef NDEBUG
#define __DEBUG__
#endif




#endif
