# Watcom C++ makefile for ptc-dos-2.0.6

!ifeq config debug
cppoption = -xs -bt=dos -zq -d2
lib = ..\library\debug\ptc.lib
objdir = ..\library\debug
!else
config=release
cppoption = -xs -oneatx -bt=dos -zq
lib = ..\library\release\ptc.lib
objdir = ..\library\release
!endif

ASM_FLAGS= -f win32

objs = area.obj clear.obj clip.obj color.obj copy.obj console.obj error.obj &
       format.obj surface.obj vbe.obj vga.obj dpmi.obj palette.obj near.obj

!ifeq asm yes
asmfiles = x86_fake.obj
cppoption += -dX86_ASSEMBLER
!endif

.silent

.cpp.obj :
        wpp386 $[@ $(cppoption) -fo=$@

.asm.obj :
        nasm $(asm_flags) -o $@ $[@


$(lib) : hello $(objs) $(asmfiles)
        wlib -q -n -b $(lib) @o_files.cmd
!ifeq asm yes
        wlib -q -b $(lib) $(asmfiles)
!endif

hello : .SYMBOLIC
        echo Compiling $(config) library..

clean : .SYMBOLIC
        echo deleting library objects..
        if exist *.obj del *.obj
        if exist *.err del *.err
        if exist *.bak del *.bak

clobber : clean .SYMBOLIC
        echo deleting libraries..
        if exist ..\library\debug\ptc.lib del ..\library\debug\ptc.lib
        if exist ..\library\release\ptc.lib del ..\library\release\ptc.lib

area.obj     : area.cpp area.h .AUTODEPEND
clear.obj    : clear.cpp clear.h .AUTODEPEND
clip.obj     : clip.cpp clip.h .AUTODEPEND
color.obj    : color.cpp color.h .AUTODEPEND
copy.obj     : copy.cpp copy.h .AUTODEPEND
console.obj  : console.cpp console.h .AUTODEPEND
error.obj    : error.cpp error.h .AUTODEPEND
format.obj   : format.cpp format.h .AUTODEPEND
surface.obj  : surface.cpp surface.h .AUTODEPEND
palette.obj  : palette.cpp palette.h .AUTODEPEND
vbe.obj      : vbe.cpp vbe.h .AUTODEPEND
vga.obj      : vga.cpp vga.h .AUTODEPEND
dpmi.obj     : dpmi.cpp dpmi.h .AUTODEPEND
x86_fake.obj : x86_fake.asm .AUTODEPEND
near.obj     : near.cpp .AUTODEPEND
