# Watcom makefile for Hermes-1.2.0

.SILENT
.EXTENSIONS:
.EXTENSIONS: .exe .obj .lib .c .h .s

LIBNAME = ..\..\library\hermes.lib

ASM_FLAGS = -f win32
C_FLAGS = -oneatx -zq -bt=dos

!ifeq asm yes
ASM_FILES = x86_main.obj x86_clr.obj x86p_32.obj x86p_16.obj x86p_i8.obj &
        x86p_cpy.obj mmx_clr.obj mmxp_32.obj
C_FLAGS += -DX86_ASSEMBLER
!endif

C_FILES = Hermes.c List.c Factory.c Palette.c Format.c Clear.c Utility.c &
        Convert.c c_32.c c_24.c c_16.c c_i8.c c_muhmu.c &
        c_genrc.c c_cpy.c c_clr.c c_cnv.c
O_FILES = Hermes.obj List.obj Factory.obj Palette.obj Format.obj Clear.obj &
        Utility.obj Convert.obj c_32.obj c_24.obj c_16.obj &
        c_i8.obj c_muhmu.obj c_genrc.obj c_cpy.obj c_clr.obj c_cnv.obj

all: $(LIBNAME)

$(LIBNAME): $(O_FILES) $(ASM_FILES)
        wlib -b -n -q ..\..\library\hermes @o_files.cmd
!ifeq asm yes
        wlib -b -q ..\..\library\hermes @a_files.cmd
!endif

.c.obj:
        wcc386 $(C_FLAGS) $[@ -fo=$@

.s.obj:
        nasm $(ASM_FLAGS) $[@ -o $@

clean:  .SYMBOLIC
        del *.obj

distclean: clean     .SYMBOLIC
        del $(LIBNAME)

Hermes.obj: Hermes.c Hermes.h H_Conv.h Types.h H_Format.h H_Pal.h &
 H_Clear.h Factory.h Clear.h HermConf.h Convert.h Utility.h
List.obj: List.c List.h Types.h
Factory.obj: Factory.c Factory.h Types.h H_Format.h Clear.h HermConf.h &
 Convert.h Utility.h HeadC.h HeadX86.h HeadMMX.h
Palette.obj: Palette.c H_Format.h Types.h H_Pal.h Palette.h List.h &
 Utility.h
Format.obj: Format.c H_Format.h Types.h
Clear.obj: Clear.c H_Clear.h Types.h H_Format.h List.h Factory.h Clear.h &
 HermConf.h Convert.h Utility.h
Utility.obj: Utility.c Utility.h Types.h
Convert.obj: Convert.c H_Conv.h Types.h H_Format.h H_Pal.h Palette.h &
 List.h Factory.h Clear.h HermConf.h Convert.h Utility.h &
 HeadC.h HeadX86.h
c_32.obj: c_32.c HermConf.h HeadC.h Types.h Clear.h Convert.h &
 H_Format.h Utility.h
c_24.obj: c_24.c HeadC.h HermConf.h Types.h Clear.h Convert.h &
 H_Format.h Utility.h
c_16.obj: c_16.c HermConf.h HeadC.h Types.h Clear.h Convert.h &
 H_Format.h Utility.h
c_i8.obj: c_i8.c HermConf.h HeadC.h Types.h Clear.h Convert.h &
 H_Format.h Utility.h
c_muhmu.obj: c_muhmu.c HermConf.h HeadC.h Types.h Clear.h &
 Convert.h H_Format.h Utility.h
c_genrc.obj: c_genrc.c HermConf.h HeadC.h Types.h Clear.h &
 Convert.h H_Format.h Utility.h
c_cpy.obj: c_cpy.c HermConf.h HeadC.h Types.h Clear.h &
 Convert.h H_Format.h Utility.h
c_clr.obj: c_clr.c Types.h HeadC.h HermConf.h Clear.h &
 Convert.h H_Format.h Utility.h
c_cnv.obj: c_cnv.c HermConf.h Convert.h Types.h H_Format.h &
 Utility.h HeadC.h Clear.h
