/*
   Pixel format conversion interface for the HERMES library
   Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
   This source code is licensed under the GNU LGPL
  
   Please refer to the file COPYING.LIB contained in the distribution for
   licensing conditions
*/

#ifndef __HERMES_CONVERTER_H__
#define __HERMES_CONVERTER_H__

#include "Types.h"
#include "H_Format.h"

HermesHandle Hermes_ConverterInstance();


void Hermes_ConverterReturn(HermesHandle handle);


int Hermes_ConverterRequest(HermesHandle handle,HermesFormat *source,
			    HermesFormat *dest);


int Hermes_ConverterPalette(HermesHandle handle,HermesHandle sourcepal,
			    HermesHandle destpal);


int Hermes_ConverterCopy(HermesHandle handle,void *s_pixels,int s_x,int s_y,
	        	 int s_width,int s_height,int s_pitch,void *d_pixels,
			 int d_x,int d_y,int d_width,int d_height,int d_pitch);


#endif
