/*
   C clearing and converter routines for the HERMES library
   Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
   This source code is licensed under the GNU LGPL
  
   Please refer to the file COPYING.LIB contained in the distribution for
   licensing conditions
*/

#ifndef __HERMES_HEAD_C__
#define __HERMES_HEAD_C__


#include "HermConf.h"
#include "Types.h"
#include "Clear.h"
#include "Convert.h"


/* Clearer functions */

void ClearC_32(HermesClearInterface *iface) REG_PASSING;
void ClearC_24(HermesClearInterface *iface) REG_PASSING;
void ClearC_16(HermesClearInterface *iface) REG_PASSING;
void ClearC_8(HermesClearInterface *iface) REG_PASSING;

/* Macros to help with conversion routines */

#define READ16(adr) *((short16 *)adr)
#define READ32(adr) *((int32 *)adr)

#define WRITE16(adr,s) *((short16 *)adr)=s
#define WRITE32(adr,s) *((int32 *)adr)=s


/* This little definition makes everything much nicer below here */

#define CONVERT_PARAMETERS char8 *source,char8 *dest,unsigned int count


/* Converter loop for specific converters */

void ConvertC(HermesConverterInterface *) REG_PASSING;


/* Generic converters */

void ConvertC_Generic32_Generic32(HermesConverterInterface *) REG_PASSING;
void ConvertC_Generic32_Generic24(HermesConverterInterface *) REG_PASSING;
void ConvertC_Generic32_Generic16(HermesConverterInterface *) REG_PASSING;
void ConvertC_Generic32_Generic8(HermesConverterInterface *) REG_PASSING;

void ConvertC_Generic24_Generic32(HermesConverterInterface *) REG_PASSING;
void ConvertC_Generic24_Generic24(HermesConverterInterface *) REG_PASSING;
void ConvertC_Generic24_Generic16(HermesConverterInterface *) REG_PASSING;
void ConvertC_Generic24_Generic8(HermesConverterInterface *) REG_PASSING;

void ConvertC_Generic16_Generic32(HermesConverterInterface *) REG_PASSING;
void ConvertC_Generic16_Generic24(HermesConverterInterface *) REG_PASSING;
void ConvertC_Generic16_Generic16(HermesConverterInterface *) REG_PASSING;
void ConvertC_Generic16_Generic8(HermesConverterInterface *) REG_PASSING;


/* From muhmu */

void ConvertC_muhmu32_32rgb888(CONVERT_PARAMETERS);
void ConvertC_muhmu32_32bgr888(CONVERT_PARAMETERS);
void ConvertC_muhmu32_24rgb888(CONVERT_PARAMETERS);
void ConvertC_muhmu32_24bgr888(CONVERT_PARAMETERS);
void ConvertC_muhmu32_16rgb565(CONVERT_PARAMETERS);
void ConvertC_muhmu32_16bgr565(CONVERT_PARAMETERS);
void ConvertC_muhmu32_16rgb555(CONVERT_PARAMETERS);
void ConvertC_muhmu32_16bgr555(CONVERT_PARAMETERS);
void ConvertC_muhmu32_8rgb332(CONVERT_PARAMETERS);


/* From 32 bit RGB */

void ConvertC_32rgb888_32bgr888(CONVERT_PARAMETERS);
void ConvertC_32rgb888_24rgb888(CONVERT_PARAMETERS);
void ConvertC_32rgb888_24bgr888(CONVERT_PARAMETERS);
void ConvertC_32rgb888_16rgb565(CONVERT_PARAMETERS);
void ConvertC_32rgb888_16bgr565(CONVERT_PARAMETERS);
void ConvertC_32rgb888_16rgb555(CONVERT_PARAMETERS);
void ConvertC_32rgb888_16bgr555(CONVERT_PARAMETERS);
void ConvertC_32rgb888_8rgb332(CONVERT_PARAMETERS);


/* From 24 bit RGB */

void ConvertC_24rgb888_32rgb888(CONVERT_PARAMETERS);
void ConvertC_24rgb888_24bgr888(CONVERT_PARAMETERS);
void ConvertC_24rgb888_16rgb565(CONVERT_PARAMETERS);
void ConvertC_24rgb888_16rgb555(CONVERT_PARAMETERS);
void ConvertC_24rgb888_8rgb332(CONVERT_PARAMETERS);


/* From 16 bit RGB */

void ConvertC_16rgb565_32rgb888(CONVERT_PARAMETERS);
void ConvertC_16rgb565_32bgr888(CONVERT_PARAMETERS);
void ConvertC_16rgb565_24rgb888(CONVERT_PARAMETERS);
void ConvertC_16rgb565_24bgr888(CONVERT_PARAMETERS);
void ConvertC_16rgb565_16bgr565(CONVERT_PARAMETERS);
void ConvertC_16rgb565_16rgb555(CONVERT_PARAMETERS);
void ConvertC_16rgb565_16bgr555(CONVERT_PARAMETERS);
void ConvertC_16rgb565_8rgb332(CONVERT_PARAMETERS);


/* From 8 bit indexed */
void ConvertC_index8_32(HermesConverterInterface *) REG_PASSING;
void ConvertC_index8_24(HermesConverterInterface *) REG_PASSING;
void ConvertC_index8_16(HermesConverterInterface *) REG_PASSING;


void CopyC_4byte(CONVERT_PARAMETERS);
void CopyC_3byte(CONVERT_PARAMETERS);
void CopyC_2byte(CONVERT_PARAMETERS);
void CopyC_1byte(CONVERT_PARAMETERS);


#endif
