/*
   Factory methods header for the HERMES library
   Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
   This source code is licensed under the GNU LGPL
  
   Please refer to the file COPYING.LIB contained in the distribution for
   licensing conditions
*/

#ifndef __HERMES_FACTORY__
#define __HERMES_FACTORY__

#include "Types.h"
#include "H_Format.h"
#include "Clear.h"
#include "Convert.h"


/* Initialise factory */
void Hermes_Factory_Init();


/* Get a clearer function for bits / pixel */
HermesClearer *Hermes_Factory_getClearer(int32 bits);


/* Get a converter for conversion from source to dest */
HermesConverter *Hermes_Factory_getConverter(HermesFormat *source, 
					     HermesFormat *dest);

/* Get a converter for equal formats with source format bits / dest format
   bits */
HermesConverter *Hermes_Factory_getEqualConverter(int bits);


/* Generate lookup tables for x86 converters */
void Hermes_Factory_x86_Gentables();

#endif




