/*
   Header definitions for format converters for the HERMES library
   Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
   This source code is licensed under the GNU LGPL
  
   Please refer to the file COPYING.LIB contained in the distribution for
   licensing conditions
*/

#ifndef __HERMES_INTERNAL_CONVERT__
#define __HERMES_INTERNAL_CONVERT__

#include "Types.h"
#include "H_Format.h"
#include "Utility.h"
#include "HermConf.h"


/* Pointer to specialised (one-scanline-only) conversion function */

typedef void (*HermesConverterPtr)(char8 *source,char8 *dest,
				   unsigned int count);



/* Structure for conversion loop routines, don't be scared, size does NOT
   matter in this case :) */

typedef struct {
  char8 *s_pixels;
  int s_width,s_height;
  int s_add;                        /* Offset to next line from end of line */

  char8 *d_pixels;
  int d_width,d_height;
  int d_add;                        

  HermesConverterPtr func;

  int32 *lookup;                    /* Palette lookup table ptr, for 8 bit */

  int s_pitch;                      /* Source and destination pitch, */
  int d_pitch;                      /* only used by C routines */

  HermesGenericInfo info;           /* Only used by generic converters */
  int32 mask_r,mask_g,mask_b;       /* Only used by generic converters */
} HermesConverterInterface;



/* Pointer to loop function (C, assembler main loop, generic routines) */

typedef void (*HermesConverterLoopPtr)(HermesConverterInterface*) REG_PASSING;


typedef struct {
  HermesFormat source,dest;                /* Source and destination format */
  int32* lookup;                           /* Pointer to lookup table (8bit) */

  char generic;                            /* Flag for generic converters */

  HermesConverterLoopPtr loopnormal;       /* Loop routine for normal conv. */
  HermesConverterLoopPtr loopstretch;

  HermesConverterPtr normal;               /* One-scanline routine */
  HermesConverterPtr stretch;
} HermesConverter;


extern HermesConverter **standardConverters[];
extern HermesConverter *equalConverters[];

extern int numConverters[];


#endif


