# Watcom C++ top level makefile for ptc-dos-2.0.6

version=2.0.6

.silent

!ifeq asm yes
ASMFLAG = "asm=yes"
!endif

all : debug release hermes ptcexamples ptcdemos .SYMBOLIC

debug : .SYMBOLIC
        cd source
        wmake /h clean
        wmake /h config=debug $(ASMFLAG)
        cd ..

release : .SYMBOLIC
        cd source
        wmake /h clean
        wmake /h config=release $(ASMFLAG)
        cd ..

hermes : .SYMBOLIC
        cd source\hermes
        wmake /h clean
        wmake /h $(ASMFLAG)
        cd ..\..

ptcexamples : .SYMBOLIC
        cd examples
        wmake /h clean
        wmake /h
        cd ..

ptcdemos : .SYMBOLIC
        cd demos
        wmake /h clean
        wmake /h
        cd ..

clean : .SYMBOLIC
        cd source
        wmake /h clean
        cd hermes
        wmake /h clean
        cd ..\..\examples
        wmake /h clean
        cd ..\demos
        wmake /h clean
        cd ..

clobber : .SYMBOLIC
        cd source
        wmake /h clobber
        cd hermes
        wmake /h distclean
        cd ..\..\examples
        wmake /h clobber
        cd ..\demos
        wmake /h clobber
        cd ..

# only reason I do it like this is it's the only way around LFN hassles.
dist : .SYMBOLIC
        if exist ptcdos.zip del ptcdos.zip
        if exist ptc-dos-$(version).zip del ptc-dos-$(version).zip
        pkzip -ex -r -p ptcdos *.*
        ren ptcdos.zip ptc-dos-$(version).zip
