# Watcom C++ makefile for examples for ptc-dos-2.0.6

hermes = ..\library\hermes.lib

!ifeq config debug
cppoption = -xs -bt=dos -I..\source -zq -d2
ptclib = ..\library\debug\ptc.lib
linkopt = debug all option quiet option stack=256k
!else
cppoption = -xs -oneatx -bt=dos -I..\source -zq
ptclib = ..\library\release\ptc.lib
linkopt = option quiet option stack=256k
!endif


.silent

all :   area clear hicolor image palette pixel random .SYMBOLIC

clean : .SYMBOLIC
        echo deleting example objects..
        if exist *.obj del *.obj

clobber : clean .SYMBOLIC
        echo deleting executables..
        if exist *.exe del *.exe

area : area.exe .SYMBOLIC
clear : clear.exe .SYMBOLIC
hicolor : hicolor.exe .SYMBOLIC
image : image.exe .SYMBOLIC
palette : palette.exe .SYMBOLIC
pixel : pixel.exe .SYMBOLIC
random : random.exe .SYMBOLIC

.cpp.obj :
        wpp386 $[@ $(cppoption)

area.exe : area.obj $(ptclib) $(hermes)
        echo compiling Area example..
        wlink $(linkopt) f area l $(ptclib), $(hermes)

clear.exe : clear.obj $(ptclib) $(hermes)
        echo compiling Clear example..
        wlink $(linkopt) f clear l $(ptclib), $(hermes)

hicolor.exe : hicolor.obj $(ptclib) $(hermes)
        echo compiling Hicolor example..
        wlink $(linkopt) f hicolor l $(ptclib), $(hermes)

image.exe : image.obj $(ptclib) $(hermes)
        echo compiling Image example..
        wlink $(linkopt) f image l $(ptclib), $(hermes)

palette.exe : palette.obj $(ptclib) $(hermes)
        echo compiling Palette example..
        wlink $(linkopt) f palette l $(ptclib), $(hermes)

pixel.exe : pixel.obj $(ptclib) $(hermes)
        echo compiling Pixel example..
        wlink $(linkopt) f pixel l $(ptclib), $(hermes)

random.exe : random.obj $(ptclib) $(hermes)
        echo compiling Random example..
        wlink $(linkopt) f random l $(ptclib), $(hermes)

area.obj : area.cpp .AUTODEPEND
clear.obj : clear.cpp .AUTODEPEND
hicolor.obj : hicolor.cpp .AUTODEPEND
palette.obj : palette.cpp .AUTODEPEND
pixel.obj : pixel.cpp .AUTODEPEND
random.obj : random.cpp .AUTODEPEND
