# Watcom C++ makefile for demos for ptc-dos-2.0.6

hermes = ..\library\hermes.lib

!ifeq config debug
cppoption = -xs -bt=dos -I..\source -zq -d2
ptclib = ..\library\debug\ptc.lib
linkopt = debug all option quiet option stack=256k
!else
cppoption = -xs -oneatx -bt=dos -I..\source -zq
ptclib = ..\library\release\ptc.lib
linkopt = option quiet option stack=256k
!endif


.silent

all :   fire flower lights texwarp .SYMBOLIC

clean : .SYMBOLIC
        echo deleting demo objects..
        if exist *.obj del *.obj

clobber : clean .SYMBOLIC
        echo deleting executables..
        if exist *.exe del *.exe

fire : fire.exe .SYMBOLIC
flower : flower.exe .SYMBOLIC
lights : lights.exe .SYMBOLIC
texwarp : texwarp.exe .SYMBOLIC

.cpp.obj :
        wpp386 $[@ $(cppoption)

fire.exe : fire.obj $(ptclib) $(hermes)
        echo compiling Fire example..
        wlink $(linkopt) f fire l $(ptclib), $(hermes)

flower.exe : flower.obj $(ptclib) $(hermes)
        echo compiling Flower example..
        wlink $(linkopt) f flower l $(ptclib), $(hermes)

lights.exe : lights.obj $(ptclib) $(hermes)
        echo compiling Lights example..
        wlink $(linkopt) f lights l $(ptclib), $(hermes)

texwarp.exe : texwarp.obj $(ptclib) $(hermes)
        echo compiling Warp example..
        wlink $(linkopt) f texwarp l $(ptclib), $(hermes)

fire.obj : fire.cpp .AUTODEPEND
flower.obj : flower.cpp .AUTODEPEND
lights.obj : lights.cpp .AUTODEPEND
texwarp.obj : texwarp.cpp .AUTODEPEND
