//
// GDI Console class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// include files
#include <stdio.h>
#include <string.h>
#include <fstream.h>
#include "Core/Key.h"
#include "Core/Area.h"
#include "Core/Color.h"
#include "Core/Error.h"
#include "Core/Config.h"
#include "Core/Clipper.h"
#include "Core/Console.h"



DLLAPI PTCAPI GDIConsole::GDIConsole()
{
    // error message
    throw Error("GDI console is not implemented yet!");
}


DLLAPI PTCAPI GDIConsole::~GDIConsole()
{
}




DLLAPI void PTCAPI GDIConsole::configure(const char file[])
{
    // open configuration file
    ifstream is(file,ios::in | ios::nocreate);
    
    // check stream
    if (!is) return;

    // read option strings
    while (!is.eof())
    {
        // option line
        char line[1024];

        // read line from stream
        is.getline(line,1024);

        // process option
        option(line);
    }
}




DLLAPI bool PTCAPI GDIConsole::option(const char option[])
{
    return false;
}




DLLAPI const Mode* PTCAPI GDIConsole::modes()
{
    // fudge mode list...
    m_modes[0] = Mode(320,200,Format(8));
    m_modes[1] = Mode(320,240,Format(8));
    m_modes[2] = Mode(512,384,Format(8));
    return m_modes;
}




DLLAPI void PTCAPI GDIConsole::open(const char title[],int pages)
{
}


DLLAPI void PTCAPI GDIConsole::open(const char title[],const Format &format,int pages)
{
}


DLLAPI void PTCAPI GDIConsole::open(const char title[],int width,int height,const Format &format,int pages)
{
}


DLLAPI void PTCAPI GDIConsole::open(const char title[],const Mode &mode,int pages)
{
}


DLLAPI void PTCAPI GDIConsole::close()
{
}





DLLAPI void PTCAPI GDIConsole::flush()
{
}


DLLAPI void PTCAPI GDIConsole::finish()
{
}


DLLAPI void PTCAPI GDIConsole::update()
{
}


DLLAPI void PTCAPI GDIConsole::update(const Area &area)
{
}




DLLAPI bool PTCAPI GDIConsole::key()
{
    return false;
}

                         
DLLAPI Key PTCAPI GDIConsole::read()
{
    static Key key;
    return key;
}




DLLAPI void PTCAPI GDIConsole::copy(BaseSurface &surface)
{
}


DLLAPI void PTCAPI GDIConsole::copy(BaseSurface &surface,const Area &source,const Area &destination)
{
}




DLLAPI void* PTCAPI GDIConsole::lock()
{
    return 0;
}


DLLAPI void PTCAPI GDIConsole::unlock()
{
}




DLLAPI void PTCAPI GDIConsole::load(const void *pixels,int width,int height,int pitch,const Format &format,const Palette &palette)
{
}


DLLAPI void PTCAPI GDIConsole::load(const void *pixels,int width,int height,int pitch,const Format &format,const Palette &palette,const Area &source,const Area &destination)
{
}




DLLAPI void PTCAPI GDIConsole::save(void *pixels,int width,int height,int pitch,const Format &format,const Palette &palette)
{
}


DLLAPI void PTCAPI GDIConsole::save(void *pixels,int width,int height,int pitch,const Format &format,const Palette &palette,const Area &source,const Area &destination)
{
}




DLLAPI void PTCAPI GDIConsole::clear()
{
}


DLLAPI void PTCAPI GDIConsole::clear(const Color &color)
{
}


DLLAPI void PTCAPI GDIConsole::clear(const Color &color,const Area &area)
{
}




DLLAPI void PTCAPI GDIConsole::palette(const Palette &palette)
{
}


DLLAPI const Palette& PTCAPI GDIConsole::palette() const
{
    static Palette palette;
    return palette;
}




DLLAPI void PTCAPI GDIConsole::clip(const Area &area)
{
}




DLLAPI int PTCAPI GDIConsole::width() const
{
    return 0;
}


DLLAPI int PTCAPI GDIConsole::height() const
{
    return 0;
}


DLLAPI int PTCAPI GDIConsole::pages() const
{
    return 0;
}


DLLAPI int PTCAPI GDIConsole::pitch() const
{
    return 0;
}


DLLAPI const Area& PTCAPI GDIConsole::area() const
{
    static Area area;
    return area;
}


DLLAPI const Area& PTCAPI GDIConsole::clip() const
{
    static Area area;
    return area;
}


DLLAPI const Format& PTCAPI GDIConsole::format() const
{
    static Format format;
    return format;
}


DLLAPI const char* PTCAPI GDIConsole::name() const
{
    // get name
    return "GDI";
}


DLLAPI const char* PTCAPI GDIConsole::title() const
{
    return "title";
}


DLLAPI const char* PTCAPI GDIConsole::information() const
{
    return "information";
}




DLLAPI HWND PTCAPI GDIConsole::window() const
{
    return 0;
}


DLLAPI LPDIRECTDRAW PTCAPI GDIConsole::lpDD() const
{
    return 0;
}



DLLAPI LPDIRECTDRAW2 PTCAPI GDIConsole::lpDD2() const
{
    return 0;
}



DLLAPI LPDIRECTDRAWSURFACE PTCAPI GDIConsole::lpDDS() const
{
    return 0;
}
