//
// Palette class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_PALETTE_H
#define __PTC_PALETTE_H

// include files
#include "Types.h"




class Palette
{
    public:

        // setup
        Palette();
        Palette(const int32 data[]);
        Palette(const Palette &palette);
        ~Palette();

        // memory access
        int32* lock();
        void unlock();

        // load palette data
        void load(const int32 data[]);

        // save palette data
        void save(int32 data[]) const;
        
        // get palette data
        const int32* data() const;

        // operators
        Palette& operator =(const Palette &palette);
        bool operator ==(const Palette &palette) const;
        bool operator !=(const Palette &palette) const;

    private:

        // locked flag
        bool m_locked;

        // palette data
        int32 m_data[256];
};




#endif
