//
// Copy class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include <string.h>
#include "Copy.h"
#include "Error.h"
#include "Format.h"
#include "Config.h"




Copy::Copy()
{
    // default constructor
}


Copy::~Copy()
{
    // destructor
}




void Copy::request(const Format &source,const Format &destination)
{
    //
    // NOTE: this copy implementation does not support pixel format 
    // conversion or stretching.
    //
    // To support pixel format conversion and stretching in your PTC
    // implementation you will need to upgrade the copy object to use the
    // Hermes library.
    //
    // To do this, you must download the latest version of Hermes from
    // http://hermes.terminal.at and get the latest version of the Hermes
    // Kit from the OpenPTC developers download site:
    // http://www.gaffer.org/ptc/download/development/hermes
    //
    // Read the text files that come with the Hermes Kit for further
    // instructions.
    //

    // check that the source and destination formats are the same
    if (source!=destination) throw Error("pixel format conversion is not supported");

    // set bytes per pixel
    m_bytes = source.bits()/8;
}




void Copy::palette(const Palette &source,const Palette &destination)
{
    // set conversion palettes
}




void Copy::copy(const void *source_pixels,int source_x,int source_y,int source_width,int source_height,int source_pitch,
                void *destination_pixels,int destination_x,int destination_y,int destination_width,int destination_height,int destination_pitch)
{
    #ifdef __DEBUG__

        //
        // This checking is performed only when __DEBUG__ is defined,
        // and can be used to track down errors early caused by passing
        // null pointers to surface and console functions.
        //
        // Even though technicially it is the users responsibility
        // to ensure that all pointers are non-null, it is useful
        // to provide a check here in debug build to prevent such
        // bugs from ever occuring.
        //
        // The checking function also tests that the source and destination
        // pointers are not the same, a bug that can be caused by copying
        // a surface to itself. The nature of the copy routine is that
        // this operation is undefined if the source and destination memory
        // areas overlap.
        //

        // check source pointer
        if (!source_pixels) throw Error("null source pointer in copy");

        // check destination pointer
        if (!destination_pixels) throw Error("null destination pointer in copy");

        // check that source and destination are not identical
        if (source_pixels==destination_pixels) throw Error("identical source and destination pointers in copy");

    #else

        // no checking is performed in release build

    #endif
    
    // check that source and destination width and height are the same
    if (source_width!=destination_width || source_height!=destination_height) throw Error("stretching is not implemented");

    // setup memory pointers
    const char8 *source = ((const char8*)source_pixels) + source_pitch*source_y + source_x*m_bytes;
    char8 *destination  = ((char8*)destination_pixels) + destination_pitch*destination_y + destination_x*m_bytes;

    // setup data
    const int width  = source_width;
    const int height = source_height;
    const int bytes  = width * m_bytes;

    // copy a line at a time
    for (int y=0; y<height; y++)
    {
        // copy line
        memcpy(destination,source,bytes);

        // next line
        source += source_pitch;
        destination += destination_pitch;
    }
}


bool Copy::option(const char option[])
{
    //
    // Handle copy option strings
    // --------------------------
    //
    // This function will accept option strings to control how pixel data 
    // is copied from one buffer to another.
    //
    // Options strings are case independent.
    //
    //

    // not recognized
    return false;
}
