//
// Generic C clear definitions for the HERMES library
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions
//

#ifndef __HERMES_CLEAR_GC_H__
#define __HERMES_CLEAR_GC_H__

#include <stdlib.h>
#include "Base.h"

void Hermes_Clear_GC_init();

void Hermes_Clear_GC_close();

char Hermes_Clear_GC_request(HermesFormat *format);

void Hermes_Clear_GC_clear(void *pixels,int x1,int y1,int width,int height,
			   int pitch,int32 r,int32 g,int32 b,char8 index);

extern BaseClear Hermes_Clear_GC;


// Actual clearing functions

void Hermes_GC_Clear_32(char8 *dest,int32 value,unsigned int width,
			unsigned int height,int add);
void Hermes_GC_Clear_24(char8 *dest,int32 value,unsigned int width,
			unsigned int height,int add);
void Hermes_GC_Clear_16(char8 *dest,int32 value,unsigned int width,
			unsigned int height,int add);
void Hermes_GC_Clear_8(char8 *dest,int32 value,unsigned int width,
		       unsigned int height,int add);

#endif

