//
// Error class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include "Error.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>




Error::Error()
{
    // defaults
    defaults();
}


Error::Error(const char message[])
{
    // allocate new message
    m_message = new char[strlen(message)+1];

    // set error message
    strcpy(this->m_message,message);
}


Error::Error(const Error &other)
{
    // defaults
    defaults();

    // assignment
    *this = other;
}


Error::~Error()
{
    // destructor
}




void Error::rethrow(const char message[])
{
    // allocate temporary message
    char *new_message = new char[strlen(message)+strlen("\n")+strlen(m_message)+1];

    // compose new message string
    sprintf(new_message,"%s\n%s",message,m_message);

    // delete message
    delete[] m_message;

    // setup to new message
    m_message = new_message;

    // rethrow
    throw *this;
}




void Error::report() const
{
    // report error
    printf("error: %s\n",m_message);

    // exit
    exit(1);
}




const char* Error::message() const
{
    // get message
    return m_message;
}




Error& Error::operator =(const Error &other)
{
    // check if other message string will fit in this one
    if (strlen(other.m_message)>strlen(m_message))
    {
        // free old message
        delete[] m_message;

        // allocate new message
        m_message = new char[strlen(other.m_message)];
    }

    // copy error message string
    strcpy(m_message,other.m_message);

    // finished
    return *this;
}


bool Error::operator ==(const Error &other) const
{
    // is equal to
    if (!strcmp(other.m_message,m_message)) return true;
    else return false;
}


bool Error::operator !=(const Error &other) const
{
    // not equal to
    return !(*this==other);
}




void Error::defaults()
{
    // defaults
    m_message = new char[1];
    m_message[0] = 0;
}
