//
// Format class for PTC 2.0 C++ API - HERMES INTERFACE PACK VERSION
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include "Error.h"
#include "Format.h"

extern "C" {
#include "Hermes/Hermes.h"
}


Format::Format()
{
    // defaults
    m_format.r=m_format.g=m_format.b=m_format.a=0;
    m_format.bits=0;
    m_format.indexed=0;
}


Format::Format(int bits)
{
    // check bits per pixel
    if (bits!=8) throw Error("only 8 bits per pixel is supported for indexed color");
    
    m_format.r=m_format.g=m_format.b=m_format.a=0;
    m_format.bits=8;
    m_format.indexed=1;
}


Format::Format(int bits,int32 r,int32 g,int32 b,int32 a)
{
    // check bits per pixel
    if (bits%8 || bits<0 || bits>32) throw Error("unsupported bits per pixel for direct color");

    // direct color

    m_format.r=r;
    m_format.g=g;
    m_format.b=b;
    m_format.a=a;
    m_format.bits=bits;
    m_format.indexed=0;
}


Format::Format(const Format &other)
{
    // copy constructor
    Hermes_FormatCopy(const_cast<HermesFormat*>(&other.m_format),&m_format);
}




int32 Format::r() const
{
    // get r
    return m_format.r;
}


int32 Format::g() const
{
    // get g
    return m_format.g;
}


int32 Format::b() const
{
    // get b
    return m_format.b;
}


int32 Format::a() const
{
    // get a
    return m_format.a;
}


int Format::bits() const
{
    // get bits
    return m_format.bits;
}


int Format::bytes() const
{
    // get bits
    return m_format.bits>>3;
}


bool Format::direct() const
{
    // get direct
    return !m_format.indexed;
}


bool Format::indexed() const
{
    // get indexed
    return m_format.indexed;
}




Format& Format::operator =(const Format &other)
{
    // assignment
    if (this!=&other)
    Hermes_FormatCopy(const_cast<HermesFormat*>(&other.m_format),&m_format);

    return *this;
}


bool Format::operator ==(const Format &other) const
{
    // equal to
    return Hermes_FormatEquals(const_cast<HermesFormat*>(&other.m_format),
			       const_cast<HermesFormat*>(&m_format));
}


bool Format::operator !=(const Format &other) const
{
    // not equal to
    return !(*this==other);
}







