//
// Copy class for PTC 2.0 C++ API - HERMES INTERFACE PACK
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// The PTC 2.0 C++ API is (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions
//

#include <string.h>
#include "Copy.h"
#include "Error.h"
#include "Format.h"
#include "Palette.h"



Copy::Copy()
{ 
    if (!Hermes_Init())
    throw Error("Could not initialise HERMES");

    // Ask Hermes for a converter instance, no dithering or anything fancy

    m_flags=HERMES_CONVERT_NORMAL;

    m_handle=Hermes_ConverterInstance(m_flags);

    if (!m_handle) 
    throw Error("Could not obtain Converter Instance from HERMES");
}


Copy::~Copy()
{ 
    // Give Hermes back the converter instance

    Hermes_ConverterReturn(m_handle);
}



void Copy::request(const Format &source,const Format &destination)
{ 
    // Request a format conversion from Hermes

    if(!Hermes_ConverterRequest(m_handle,
				const_cast<HermesFormat*>(&source.m_format),
				const_cast<HermesFormat*>(&destination.m_format)))
    throw Error("Requested format conversion not available");

}


void Copy::palette(const Palette &source, const Palette &destination)
{
    // Set palette parameters for Hermes

    if (!Hermes_ConverterPalette(m_handle,source.m_handle,
				 destination.m_handle))
    throw Error("Could not set conversion palette");

}


void Copy::copy(const void *s_pixels,int s_x,int s_y,int s_width,
  int s_height,int s_pitch,void *d_pixels,int d_x,int d_y,int d_width,
  int d_height,int d_pitch)
{ 
    if(!Hermes_ConverterCopy(m_handle,const_cast<void *>(s_pixels),s_x,s_y,
	  		     s_width,s_height,s_pitch,d_pixels,d_x,d_y,d_width,
			     d_height,d_pitch))
    throw Error("HERMES could not convert color formats");

}


bool Copy::option(const char option[])
{

    // Don't worry about the complexity of this code. First of all, it isn't
    // really complex, it just looks like it. Second, only lunatics will
    // change dithering more than once (or even in a loop! :)


    // Check if we need to switch to dithering

    if (!strcmp(option,"enable dithering") && 
	!(m_flags&HERMES_CONVERT_DITHER)) {

      // Set new flags
      m_flags|=HERMES_CONVERT_DITHER;

      // Return old converter
      Hermes_ConverterReturn(m_handle);

      // Obtain new converter
      m_handle=Hermes_ConverterInstance(m_flags);

      if (!m_handle)
      throw Error("Could not obtain new converter when changing to dithering");

      return true;
    }


    // Check if dithering is enabled but requested to be disabled

    if (!strcmp(option,"disable dithering") &&
	(m_flags&HERMES_CONVERT_DITHER)) {

      // Clear out dithering flag
      m_flags&=~HERMES_CONVERT_DITHER;

      // Return old converter
      Hermes_ConverterReturn(m_handle);

      // Obtain new converter
      m_handle=Hermes_ConverterInstance(m_flags);

      if (!m_handle)
      throw Error("Could not obtain new converter when turning off dithering");

      return true;
    }

      
    // Default to 'cannot handle'

    return false;
}
