//
// Clip class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include "Clip.h"
#include "Area.h"




Area Clip::clip(const Area &clip,const Area &area)
{
    // get in coordinates
    int left   = area.left();
    int right  = area.right();
    int top    = area.top();
    int bottom = area.bottom();

    // get clip coordinates
    const int clip_left   = clip.left();
    const int clip_right  = clip.right();
    const int clip_top    = clip.top();
    const int clip_bottom = clip.bottom();

    // clip left
    if (left<clip_left)  left = clip_left;
    if (left>clip_right) left = clip_right;
    
    // clip right
    if (right<clip_left)  right = clip_left;
    if (right>clip_right) right = clip_right;
    
    // clip top
    if (top<clip_top)    top = clip_top;
    if (top>clip_bottom) top = clip_bottom;

    // clip bottom
    if (bottom<clip_top)    top = clip_top;
    if (bottom>clip_bottom) top = clip_bottom;

    // return clipped area
    return Area(left,top,right,bottom);
}




void Clip::clip(const Area &clip_source,const Area &source,Area &clipped_source,
                const Area &clip_destination,const Area &destination,Area &clipped_destination)
{
    // temporary: clip areas independently
    clipped_source = Clip::clip(clip_source,source);
    clipped_destination = Clip::clip(clip_destination,destination);

    /*
    // clip source area
    clipped_source = Clip::clip(clip_source,source);

    // check for early source area exit
    if (clipped_source.width()==0 || clipped_source.height()==0)
    {
        // source area is zero
        clipped_destination = Area(0,0,0,0);
        return;
    }

    // calculate deltas in source clip
    float source_delta_left   = (float) ( clipped_source.left()   - source.left()   );
    float source_delta_right  = (float) ( clipped_source.right()  - source.right()  );
    float source_delta_top    = (float) ( clipped_source.top()    - source.top()    );
    float source_delta_bottom = (float) ( clipped_source.bottom() - source.bottom() );

    // note: temporarily assumes source and destination areas have same width and height !

    // adjust destination by source deltas
    Area adjusted_destination = Area( destination.left()+source_delta_left
    */
}
