//
// Clear class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_CLEAR_H
#define __PTC_CLEAR_H

// include files
#include "Index.h"

extern "C" {
#include "Hermes/Hermes.h"
}

class Clear
{
    public:

        // default constructor
        Clear();

	// destructor
	~Clear();

        // request clear
        void request(const Format &format);
        
        // clear pixels
        void clear(void *pixels,int x,int y,int width,int height,int pitch,
		   const Color &color);

    private:
	Clear(const Clear &other);
	Clear& operator=(const Clear &other);

	HermesHandle m_handle;

	// Pointer to current format. Has to be a pointer because of 
	// cyclic dependencies

	Format *m_format;
};




#endif
