
BITS 32

GLOBAL ConvertMMX
GLOBAL checkMMX
	
GLOBAL ConvertMMX32_32RGB888
GLOBAL ConvertMMX32_16RGB565

	
SECTION .data

ALIGN 16	
mmx32_rgb565_rb dd 00f800f8h,00f800f8h
mmx32_rgb565_add dd 20000004h,20000004h
mmx32_rgb565_g dd 0000fc00h,0000fc00h
cpu_flags dd 0
		
SECTION .text


ConvertMMX32_32RGB888:

.L1:
	movq mm0,[esi]
	add esi,8

	movq [edi],mm0
	add edi,8

	dec ecx
	dec ecx
	jnz .L1
	
	jmp globalreturn


	
ConvertMMX32_16RGB565:
	movq mm6,qword [mmx32_rgb565_g]
	movq mm7,qword [mmx32_rgb565_add]
	
.L1:	
	movq mm0,[esi]
	add esi,8

	movq mm1,mm0
	pand mm0,qword [mmx32_rgb565_rb]

	pmaddwd mm0,mm7
	pand mm1,mm6

	por mm0,mm1
	psrlq mm0,5

	punpckhwd mm0,mm0

	movd [edi],mm0

	add edi,4
	
	sub ecx,2
	jz .L2
	jmp .L1

.L2:	
	jmp globalreturn

	
;; ConvertMMX:	 
;; EAX = ConverterInfo*
;; --------------------------------------------------------------------------
;; ConverterInfo (ebp+..)
;;   0:	void *s_pixels
;;   4:	int s_width
;;   8:	int s_height
;;  12:	int s_add
;;  16:	void *d_pixels
;;  20:	int d_width
;;  24:	int d_height
;;  28:	int d_add
;;  32:	void (*converter_function)() 
ConvertMMX:

	cmp dword [eax+4],0
	je endconvert
	
	push ebp
	mov ebp,eax
	
	mov esi,[ebp+0]
	mov edi,[ebp+16]

	
y_loop:	
	mov ecx,[ebp+4]

	jmp [ebp+32]

globalreturn:	
	add esi,[ebp+12]
	add edi,[ebp+28]
	
	dec dword  [ebp+24]
	jnz y_loop

	
	pop ebp

endconvert:
	emms
	ret		


	
checkMMX:
	pusha
	
	mov eax,1
	cpuid

	mov [cpu_flags],edx

	popa

	mov eax,[cpu_flags]
	ret
	
