//
// Copy class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_COPY_H
#define __PTC_COPY_H

// include files
#include "../Format.h"
#include "BaseConverter.h"
#include <vector.h>

class Copy 
{
public:
  Copy();
  //  Copy(const Format &source,const Format &destination);
  ~Copy();

  // set pixel formats
  void formats(const Format &source,const Format &destination);

  // set source palette
  void palette(const int32 palette[]);

  // copy pixels
  void copy(const void *s_pixels,int s_x,int s_y,int s_width,int s_height,
	    int s_pitch,void *d_pixels,int d_x,int d_y,int d_width,
	    int d_height,int d_pitch);

private:
  // Will hold a C, ASM, MMX converter, ...
  BaseConverter **m_converters;

  // Converter that will be used for a specific copy request
  BaseConverter *m_active;

  // Number of converters available
  int m_numconverters;
};




#endif
