#include <iostream.h>
#include <list.h>
#include "ptconfig.h"
#include "Error.h"

#include "Converter_C.h"
#include "Converter_x86.h"
#include "Converter_mmx.h"

#include "Copy.h"

Copy::Copy()
{ m_numconverters=3;

  m_converters=new (BaseConverter *)[m_numconverters];

  m_converters[0]=new Converter_MMX;
  m_converters[1]=new Converter_x86;
  m_converters[2]=new Converter_C;
}

Copy::~Copy()
{
  for(int i=0;i<m_numconverters;i++)
  delete m_converters[i];

  delete [] m_converters;
  
}


void Copy::formats(const Format &source,const Format &destination)
{ 
  for(int i=0;i<m_numconverters;i++)
  { if(m_converters[i]->formats(source,destination))
    { m_active=m_converters[i];
      return;
    }
  }

  throw Error("Requested format conversion not available");
}


void Copy::palette(const int32 palette[])
{
  m_active->palette(palette);
}


void Copy::copy(const void *s_pixels,int s_x,int s_y,int s_width,int s_height,
  int s_pitch,void *d_pixels,int d_x,int d_y,int d_width,int d_height,
  int d_pitch)
{ 
  m_active->copy(s_pixels,s_x,s_y,s_width,s_height,s_pitch,
		 d_pixels,d_x,d_y,d_width,d_height,d_pitch);
}




