#ifndef PTC_BASE_CONVERTER_X86_H__
#define PTC_BASE_CONVERTER_X86_H__

#include "BaseConverter.h"

#ifndef NO_ASSEMBLER

extern "C" void ConvertX86(ConverterInfoAsm *) __attribute__ ((regparm(1)));

class Converter_x86 : public BaseConverter {
public:
  Converter_x86();

  // Conversion from source to destination available ?
  virtual bool formats(const Format &source,const Format &destination);

  // Set palette
  virtual void palette(const int32 palette[]);

  virtual void copy(const void *s_pixels,int s_x,int s_y,int s_width,
		    int s_height,int s_pitch,void *d_pixels,int d_x,int d_y,
		    int d_width,int d_height,int d_pitch);

private:
  Format m_source,m_dest;

  // Converter function to pass to ConvertX86
  void (*m_converter)(void);
};


extern "C" void Convert32_16RGB565();
extern "C" void Convert32_32RGB888();
extern "C" void Convert32_8RGB332();



#else


class Converter_x86 : public BaseConverter {
public:
  Converter_x86() {}

  virtual bool formats(const Format &source,const Format &destination)
  { return false; }

  // Set palette
  virtual void palette(const int32 palette[]) {}

  virtual void copy(const void *s_pixels,int s_x,int s_y,int s_width,
		    int s_height,int s_pitch,void *d_pixels,int d_x,int d_y,
		    int d_width,int d_height,int d_pitch) {}
};

#endif // NO_ASSEMBLER

#endif





