//
// Error class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include <iostream.h>
#include <string.h>
#include "Error.h"



Error::Error()
{
}


Error::Error(const char message[])
{
    // set error message
    strcpy(this->m_message,message);
}


Error::Error(const Error &other)
{ // Copy using assignment

  *this=other;
}


Error::~Error()
{
}



void Error::rethrow(char message[])
{
    // rethrow
    throw *this;
}



void Error::report() const
{
    // report error
    cerr << endl << "PTC Error: " << m_message << endl;

    // exit
    exit(1);
}




const char* Error::message() const
{
    // get message
    return m_message;
}



Error& Error::operator =(const Error &other)
{
    // assignment
    strcpy(m_message,other.m_message);
    return *this;
}


bool Error::operator ==(const Error &other) const
{
    // is equal to
    if (!strcmp(other.m_message,m_message)) return true;
    else return false;
}


bool Error::operator !=(const Error &other) const
{
    // not equal to
    return !(*this==other);
}




