//
// Copy class for PTC 2.0 C++ API
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// The PTC 2.0 C++ API is (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions
//

#ifndef __PTC_COPY_H
#define __PTC_COPY_H

// include files
#include "Format.h"
#include "Hermes/Hermes.h"

class Copy 
{ 
public:
  Copy();
  ~Copy();

  // set pixel formats
  void request(const Format &source,const Format &destination,
	       const bool stretch);

  // set source palette
  void palette(const int32 palette[]);

  // copy pixels
  void copy(const void *s_pixels,int s_x,int s_y,int s_width,
	    int s_height,int s_pitch,void *d_pixels,int d_x,int d_y,
	    int d_width,int d_height,int d_pitch);

  // Convert the PTC format into a Hermes Format structure. *dest has to
  // be allocated beforehand.
private:
  void convertformat(const Format &source,HermesFormat *dest);
};




#endif

