//
// Color class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_COLOR_H
#define __PTC_COLOR_H




class Color
{
    public:

        // setup
        Color();
        Color(int index);
        Color(float r,float g,float b,float a=1.0f);
        Color(const Color &color);

        // data access
        int index() const;
        float r() const;
        float g() const;
        float b() const;
        float a() const;
        bool direct() const;
        bool indexed() const;

        // operators
        Color& operator =(const Color &other);
        bool operator ==(const Color &other) const;
        bool operator !=(const Color &other) const;

    private:

        // data
        int m_index;
        float m_r;
        float m_g;
        float m_b;
        float m_a;
        bool m_direct;
        bool m_indexed;
};




#endif
