//
// Clip class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include "Clip.h"
#include "Area.h"




Area Clip::clip(const Area &clip,const Area &area)
{
    // get in coordinates
    int left   = area.left();
    int right  = area.right();
    int top    = area.top();
    int bottom = area.bottom();

    // get clip coordinates
    int clip_left   = clip.left();
    int clip_right  = clip.right();
    int clip_top    = clip.top();
    int clip_bottom = clip.bottom();

    // clip left
    if (left<clip_left)  left = clip_left;
    if (left>clip_right) left = clip_right;
    
    // clip right
    if (right<clip_left)  right = clip_left;
    if (right>clip_right) right = clip_right;
    
    // clip top
    if (top<clip_top)    top = clip_top;
    if (top>clip_bottom) top = clip_bottom;

    // clip bottom
    if (bottom<clip_top)    top = clip_top;
    if (bottom>clip_bottom) top = clip_bottom;

    // return clipped area
    return Area(left,top,right,bottom);
}
