//
// Clear class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include <memory.h>
#include "Clear.h"
#include "Color.h"
#include "Hermes/Hermes.h"
#include "Error.h"

Clear::Clear()
{ HermesInit();
}


Clear::~Clear()
{ HermesClose();
}


void Clear::request(const Format &format)
{   if(format==m_format) return;

    static HermesFormat h_format;

    convertformat(format,&h_format);

    if(!HermesRequestClear(&h_format))
    throw Error("Request colour format cannot be cleared");

    m_format=format;
}



void Clear::clear(void *pixels,int x,int y,int width,int height,int pitch,
  const Color &color)
{ int32 r,g,b;

  if(m_format.indexed() && color.direct())
  throw Error("Can't clear indexed surface with direct colour");
  else
  if(m_format.direct() && color.indexed())
  throw Error("Can't clear direct surface with indexed colour");

  if(color.direct())
  { r=(int32)(color.r()*(float)255.0);
    g=(int32)(color.g()*(float)255.0);
    b=(int32)(color.b()*(float)255.0);

    HermesClear(pixels,x,y,width,height,pitch,r,g,b,0);
  }
  else
  HermesClear(pixels,x,y,width,height,pitch,0,0,0,color.index());
}


void Clear::convertformat(const Format& source,HermesFormat *dest)
{ dest->bpp=source.bits();
  dest->mask_r=source.r();
  dest->mask_g=source.g();
  dest->mask_b=source.b();
  dest->indexed=source.direct()?0:1;
}
