%define version 2.0.10
%define hermesversion 1.0.3

Summary: Prometheus Truecolour (PTC) for X11
Name: ptc
Version: %{version}
Release: 1
Copyright: LGPL
Group: Development/Libraries
Source: http://www.cs.ucl.ac.uk/students/c.nentwich/ptc/ptc-x11-%{version}.tar.gz
BuildRoot: /tmp
Packager: brn (brn@eleet.mcb.at)
URL: http://www.cs.ucl.ac.uk/students/c.nentwich

%description
Prometheus Truecolour (PTC) is a cross-platform low level frame buffer
access library. It was designed to achieve little more than give access
to the frame buffer and offscreen surfaces.

On top of that, PTC will convert any offscreen surfaces you use to the
screen format that is available on your platform, using highly optimised
handwritten x86 assembler or MMX routines where available.

PTC 2.0 is also available for Win32 (NT,95,98) and Java at the moment.
Work for SVGALIB, Amiga and DOS is in progress.

%prep
%setup

%build
cd Hermes
./configure
make
cd ..
./configure --prefix=$RPM_BUILD_ROOT/usr/local
make ptclib

%post
ldconfig

%postun
rmdir /usr/local/include/ptc/Hermes
rmdir /usr/local/include/ptc

%install
make install

%clean
make distclean

%files
%doc README BUGS CHANGES COPYING.LIB TODO
/usr/local/bin/ptc-config
/usr/local/lib/libptc.so.%{version}
/usr/local/lib/libptc.so
/usr/local/lib/libptc.%{version}.a
/usr/local/lib/libptc.a
/usr/local/lib/libHermes.%{hermesversion}.a
/usr/local/lib/libHermes.a
/usr/local/include/ptc/Area.h
/usr/local/include/ptc/Base.h
/usr/local/include/ptc/Clear.h
/usr/local/include/ptc/Clip.h
/usr/local/include/ptc/Color.h
/usr/local/include/ptc/Console.h
/usr/local/include/ptc/Copy.h
/usr/local/include/ptc/Error.h
/usr/local/include/ptc/Format.h
/usr/local/include/ptc/Random.h
/usr/local/include/ptc/Surface.h
/usr/local/include/ptc/X11Display.h
/usr/local/include/ptc/X11Image.h
/usr/local/include/ptc/ptc.h
/usr/local/include/ptc/ptcjni.h
/usr/local/include/ptc/ptconfig.h
/usr/local/include/ptc/Hermes/Base.h
/usr/local/include/ptc/Hermes/ClearMMX.h
/usr/local/include/ptc/Hermes/Clear_GC.h
/usr/local/include/ptc/Hermes/Clearx86.h
/usr/local/include/ptc/Hermes/Conv_GC.h
/usr/local/include/ptc/Hermes/Conv_MMX.h
/usr/local/include/ptc/Hermes/Conv_x86.h
/usr/local/include/ptc/Hermes/Head_MMX.h
/usr/local/include/ptc/Hermes/Head_x86.h
/usr/local/include/ptc/Hermes/HermConf.h
/usr/local/include/ptc/Hermes/Hermes.h
/usr/local/include/ptc/Hermes/hrconfig.h
/usr/local/include/ptc/Hermes/Types.h
