//
// Realtime raytraced tunnel for PTC 2.0 C++ API
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// The PTC 2.0 C++ API is (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions
//
// And do not just blatantly cut&paste this into your demo :)
//

#include <math.h>
#include <string.h>
#include "Calc.h"

/* VECTOR ROUTINES */

void vector_normalize(Vector v)
{ float length;

  length=v[0]*v[0]+v[1]*v[1]+v[2]*v[2];
  length=sqrt(length);

  if(length!=0)
  { v[0]/=length;
    v[1]/=length;
    v[2]/=length;
  }
  else
  { v[0]=v[1]=v[2]=0;
  }
}

void vector_times_matrix(Vector v,Matrix m,Vector res)
{ int i,j;

  for(j=0;j<3;j++)
  { res[j]=0;

    for(i=0;i<3;i++)
    res[j]+=m[j][i]*v[i];
  }
}

void matrix_idle(Matrix m)
{ memset(m,0,sizeof(Matrix));

  m[0][0]=1;
  m[1][1]=1;
  m[2][2]=1;
  m[3][3]=1;
}

void matrix_rotate_x(Matrix m,int angle,float *sintab,float *costab)
{ Matrix tmp,tmp2;

  matrix_idle(tmp);

  tmp[1][1]=costab[angle];
  tmp[2][1]=sintab[angle];
  tmp[1][2]=-sintab[angle];
  tmp[2][2]=costab[angle];

  matrix_times_matrix(tmp,m,tmp2);
  memcpy(m,tmp2,sizeof(Matrix));

}

void matrix_rotate_y(Matrix m,int angle,float *sintab,float *costab)
{ Matrix tmp,tmp2;

  matrix_idle(tmp);

  tmp[0][0]=costab[angle];
  tmp[2][0]=-sintab[angle];
  tmp[0][2]=sintab[angle];
  tmp[2][2]=costab[angle];

  matrix_times_matrix(tmp,m,tmp2);
  memcpy(m,tmp2,sizeof(Matrix));

}

void matrix_rotate_z(Matrix m,int angle,float *sintab,float *costab)
{ Matrix tmp,tmp2;

  matrix_idle(tmp);

  tmp[0][0]=costab[angle];
  tmp[1][0]=sintab[angle];
  tmp[0][1]=-sintab[angle];
  tmp[1][1]=costab[angle];

  matrix_times_matrix(tmp,m,tmp2);
  memcpy(m,tmp2,sizeof(Matrix));

}

void matrix_times_matrix(Matrix m1,Matrix m2,Matrix res)
{ int i,j,k;

  for(j=0;j<4;j++)
  for(i=0;i<4;i++)
  { res[i][j]=0;

    for(k=0;k<4;k++)
    res[i][j]+=m1[k][j]*m2[i][k];
  }
}



