//
// Native example: How to use a native mode (i.e. no format conversion)
// Copyright (c) Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU GPL
//

// include files
#include "ptc.h"


int main()
{
    try
    {
        // create format
        Format format(8);

        // create console, try and initialise 8 bit indexed
        Console console;

	console.option("dga off");

        console.open("Native mode example",320,200,format);
	
	if(console.format()!=format)
	throw Error("Native 8 bit mode not available");

        // generate palette
        int32 palette[256];
        for (int i=0; i<256; i++) palette[i] = i;

        // set console palette (only works in native mode)
        console.palette(palette);
        
        // loop until a key is pressed
        while (!console.key())
        {
            // lock the console itself
            char8 *pixels = (char8*) console.lock();

            // draw random pixels
            for (int i=0; i<100; i++)
            {
                // get random position
                int x = random(320);
                int y = random(200);

                // get random color index
                char8 index = random(256);

                // draw color [index] at position [x,y], note how the pitch
		// is used when locking the console..
                pixels[x+y*console.pitch()] = index;
            }
        
	    console.unlock();

            // update console
            console.update();
        }

        // done
        return 0;
    }
    catch (Error &error)
    {
        // report error
        error.report();
    }
}
