//
// The big fat ifdef-rich configuration header for the HERMES library
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions
//
#ifndef __HERMES_CONF_H__
#define __HERMES_CONF_H__

#ifdef __unix__
#include "hrconfig.h"
#endif 

#ifdef __CYGWIN32__
  #define __CYGNUS__
#endif

#if (_MSC_VER>=1000)
  #define __VISUALC__
#endif

#if defined(WIN32) || defined(_WIN32) || defined(WINDOWS) || defined(__NT__)
  #define __WIN32__ 1
  #define __LITTLE_ENDIAN__ 1
  #undef __BIG_ENDIAN__
#endif

#if defined(__WATCOMC__) || defined(__DJGPP__) || defined(__CYGNUS__)
  #define __LITTLE_ENDIAN__ 1
  #undef __BIG_ENDIAN__
#endif 



// Macros to help with big/little endian problems

#if defined __LITTLE_ENDIAN__
  #define R_32 2                 // Position of R,G,B in a 32 bit dword
  #define G_32 1
  #define B_32 0
  #define R_24 2                 // Position of R,G,B in a 24 bit pixel
  #define G_24 1
  #define B_24 0
  #define DWORD_BYTE0(s) s         // Shift values to get to bytes in dwords
  #define DWORD_BYTE1(s) ((s)<<8)  // Check out the bracket paranoia to    
  #define DWORD_BYTE2(s) ((s)<<16) // prevent bugs :))     
  #define DWORD_BYTE3(s) ((s)<<24)       
#elif defined __BIG_ENDIAN__
  #define R_32 1
  #define G_32 2
  #define B_32 3
  #define R_24 0
  #define G_24 1
  #define B_24 2
  #define DWORD_BYTE0(s) ((s)<<24)
  #define DWORD_BYTE1(s) ((s)<<16)
  #define DWORD_BYTE2(s) ((s)<<8)
  #define DWORD_BYTE3(s) s
#else
  #error Processor endian-ness not defined!
#endif


#endif
