//
// Generic C definitions for the HERMES library
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions
//
#ifndef __HERMES_CONV_GC_H__
#define __HERMES_CONV_GC_H__

#include <stdlib.h>
#include "Base.h"

void Hermes_GC_init();

void Hermes_GC_close();

char Hermes_GC_request(HermesFormat *source,HermesFormat *dest,char stretch);

void Hermes_GC_palette(int32 *palette);

void Hermes_GC_copy(void *s_pixels,int s_x,int s_y,int s_width,int s_height,
		   int s_pitch,void *d_pixels,int d_x,int d_y,int d_width,
		   int d_height,int d_pitch);

extern BaseConverter Hermes_Generic_C;


// Help routines
void Hermes_GC_Calculate_Generic_Info(HermesFormat *format);


// Converters
extern Hermes_Generic_Info Hermes_GC_GI;


// Macros to help with conversion routines

#define READ16(adr) *((short16 *)adr)
#define READ32(adr) *((int32 *)adr)

#define WRITE16(adr,s) *((short16 *)adr)=s
#define WRITE32(adr,s) *((int32 *)adr)=s


// This little define makes everything much nicer below here
#define CONVERT_PARAMETERS char8 *source,char8 *dest,unsigned int count

// From 32 bit RGB
void Hermes_GC_muhmu32_32rgb888(CONVERT_PARAMETERS);
void Hermes_GC_muhmu32_32bgr888(CONVERT_PARAMETERS);
void Hermes_GC_muhmu32_24rgb888(CONVERT_PARAMETERS);
void Hermes_GC_muhmu32_24bgr888(CONVERT_PARAMETERS);
void Hermes_GC_muhmu32_16rgb565(CONVERT_PARAMETERS);
void Hermes_GC_muhmu32_16bgr565(CONVERT_PARAMETERS);
void Hermes_GC_muhmu32_16rgb555(CONVERT_PARAMETERS);
void Hermes_GC_muhmu32_16bgr555(CONVERT_PARAMETERS);
void Hermes_GC_muhmu32_8rgb332(CONVERT_PARAMETERS);
void Hermes_GC_muhmu32_Generic32(CONVERT_PARAMETERS);
void Hermes_GC_muhmu32_Generic16(CONVERT_PARAMETERS);


// From 32 bit RGB
void Hermes_GC_32rgb888_32rgb888(CONVERT_PARAMETERS);
void Hermes_GC_32rgb888_32bgr888(CONVERT_PARAMETERS);
void Hermes_GC_32rgb888_24rgb888(CONVERT_PARAMETERS);
void Hermes_GC_32rgb888_24bgr888(CONVERT_PARAMETERS);
void Hermes_GC_32rgb888_16rgb565(CONVERT_PARAMETERS);
void Hermes_GC_32rgb888_16bgr565(CONVERT_PARAMETERS);
void Hermes_GC_32rgb888_16rgb555(CONVERT_PARAMETERS);
void Hermes_GC_32rgb888_16bgr555(CONVERT_PARAMETERS);
void Hermes_GC_32rgb888_8rgb332(CONVERT_PARAMETERS);
void Hermes_GC_32rgb888_Generic32(CONVERT_PARAMETERS);
void Hermes_GC_32rgb888_Generic16(CONVERT_PARAMETERS);
void Hermes_GC_Generic32_Generic32(CONVERT_PARAMETERS);
void Hermes_GC_Generic32_Generic24(CONVERT_PARAMETERS);
void Hermes_GC_Generic32_Generic16(CONVERT_PARAMETERS);
void Hermes_GC_Generic32_Generic8(CONVERT_PARAMETERS);

// From 24 bit RGB

void Hermes_GC_24rgb888_32rgb888(CONVERT_PARAMETERS);
void Hermes_GC_24rgb888_24rgb888(CONVERT_PARAMETERS);
void Hermes_GC_24rgb888_24bgr888(CONVERT_PARAMETERS);
void Hermes_GC_24rgb888_16rgb565(CONVERT_PARAMETERS);
void Hermes_GC_24rgb888_16rgb555(CONVERT_PARAMETERS);
void Hermes_GC_24rgb888_8rgb332(CONVERT_PARAMETERS);
void Hermes_GC_24rgb888_Generic32(CONVERT_PARAMETERS);
void Hermes_GC_24rgb888_Generic16(CONVERT_PARAMETERS);
void Hermes_GC_Generic24_Generic32(CONVERT_PARAMETERS);
void Hermes_GC_Generic24_Generic24(CONVERT_PARAMETERS);
void Hermes_GC_Generic24_Generic16(CONVERT_PARAMETERS);
void Hermes_GC_Generic24_Generic8(CONVERT_PARAMETERS);

// From 16 bit RGB

void Hermes_GC_16rgb565_32rgb888(CONVERT_PARAMETERS);
void Hermes_GC_16rgb565_32bgr888(CONVERT_PARAMETERS);
void Hermes_GC_16rgb565_24rgb888(CONVERT_PARAMETERS);
void Hermes_GC_16rgb565_24bgr888(CONVERT_PARAMETERS);
void Hermes_GC_16rgb565_16rgb565(CONVERT_PARAMETERS);
void Hermes_GC_16rgb565_16bgr565(CONVERT_PARAMETERS);
void Hermes_GC_16rgb565_16rgb555(CONVERT_PARAMETERS);
void Hermes_GC_16rgb565_16bgr555(CONVERT_PARAMETERS);
void Hermes_GC_16rgb565_8rgb332(CONVERT_PARAMETERS);
void Hermes_GC_16rgb565_Generic32(CONVERT_PARAMETERS);
void Hermes_GC_16rgb565_Generic16(CONVERT_PARAMETERS);
void Hermes_GC_Generic16_Generic32(CONVERT_PARAMETERS);
void Hermes_GC_Generic16_Generic24(CONVERT_PARAMETERS);
void Hermes_GC_Generic16_Generic16(CONVERT_PARAMETERS);
void Hermes_GC_Generic16_Generic8(CONVERT_PARAMETERS);

// From 8 bit indexed
void Hermes_GC_index8_32(CONVERT_PARAMETERS);
void Hermes_GC_index8_24(CONVERT_PARAMETERS);
void Hermes_GC_index8_16(CONVERT_PARAMETERS);
void Hermes_GC_index8_i8(CONVERT_PARAMETERS);

#endif

