//
// x86 clear definitions for the HERMES library
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions
//

#ifndef __HERMES_CLEAR_X86_H__
#define __HERMES_CLEAR_X86_H__

#include <stdlib.h>
#include "Base.h"

#ifdef NO_ASSEMBLER

void Hermes_Clear_x86_init() {}

void Hermes_Clear_x86_close() {}

char Hermes_Clear_x86_request(HermesFormat *format) { return 0; }

void Hermes_Clear_x86_clear(void *pixels,int x1,int y1,int width,int height,
			    int pitch,int32 r,int32 g,int32 b,char8 index) {}

#else

void Hermes_Clear_x86_init();

void Hermes_Clear_x86_close();

char Hermes_Clear_x86_request(HermesFormat *format);

void Hermes_Clear_x86_clear(void *pixels,int x1,int y1,int width,int height,
			    int pitch,int32 r,int32 g,int32 b,char8 index);

#endif // NO_ASSEMBLER

static BaseClear Hermes_Clear_x86=
{ 0,0,0,
  NULL,
  Hermes_Clear_x86_init,
  Hermes_Clear_x86_close,
  Hermes_Clear_x86_request,
  Hermes_Clear_x86_clear
};

#endif

