//
// x86 surface clear implementation for the HERMES library
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions
//

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Hermes.h"
#include "Clearx86.h"
#include "Head_x86.h"


#ifndef NO_ASSEMBLER

static HermesClearInterface *Interface_x86=0;

#ifdef __GNUC__
void (*Hermes_x86_Clearer)(HermesClearInterface *) __attribute__ ((regparm(1)));
#else
void (*Hermes_x86_Clearer)(HermesClearInterface *);
#endif

#ifdef __WATCOMC__
#pragma aux Hermes_x86_Clearer parm [EAX] modify [EAX EBX ECX EDX ESI EDI]
#endif


void Hermes_Clear_x86_init()
{ Hermes_Clear_x86.m_format=(HermesFormat *)malloc(sizeof(HermesFormat));
  Interface_x86=(HermesClearInterface *)malloc(sizeof(HermesClearInterface));
}


void Hermes_Clear_x86_close()
{ if(Hermes_Clear_x86.m_format)
  { free(Hermes_Clear_x86.m_format);
    Hermes_Clear_x86.m_format=0;
  }

  if(Interface_x86)
  { free(Interface_x86);
    Interface_x86=0;
  }
}


char Hermes_Clear_x86_request(HermesFormat *format)
{ char found=0;

  // Done that before
  if(HermesFormatEquals(format,Hermes_Clear_x86.m_format))
  return 1;

  Hermes_x86_Clearer=0;

  switch(format->bpp)
  { case 32: Hermes_x86_Clearer=Clear32_x86;
             found=1;
	     break;

    case 24: 
	     break;

    case 16: Hermes_x86_Clearer=Clear16_x86;
             found=1;
	     break;

     case 8: Hermes_x86_Clearer=Clear8_x86;
             found=1;
	     break;
  }

  if(found)
  { HermesFormatCopy(format,Hermes_Clear_x86.m_format);
    printf("Hermes X86 Assembler Clearer\n");

    return 1;
  }

  return 0;
}


void Hermes_Clear_x86_clear(void *pixels,int x1,int y1,int width,int height,
			   int pitch,int32 r,int32 g,int32 b,char8 index)
{ 
  Hermes_Generic_Info info;
  int32 d_r,d_g,d_b;

  // No clear routine initialised or invalid width / height
  if(!Hermes_x86_Clearer) return;
  if(width<=0 || height<=0) return;


  Interface_x86->dest=(char8 *)pixels;
  Interface_x86->dest+=y1*pitch+x1*(Hermes_Clear_x86.m_format->bpp>>3);

  Interface_x86->width=width;
  Interface_x86->height=height;
  Interface_x86->add=pitch-width*(Hermes_Clear_x86.m_format->bpp>>3);


  // Generate real colour values
  if(Hermes_Clear_x86.m_format->indexed)
  { Interface_x86->value=index;
  }
  else
  { Hermes_Calculate_Generic_Info(24,16,8,Hermes_Clear_x86.m_format,
	  			  &info);
  
    Interface_x86->value=(r<<16)|(g<<8)|b;

    d_r=((Interface_x86->value>>info.r_right)<<info.r_left)&
        Hermes_Clear_x86.m_format->mask_r;
    d_g=((Interface_x86->value>>info.g_right)<<info.g_left)&
        Hermes_Clear_x86.m_format->mask_g;
    d_b=((Interface_x86->value>>info.b_right)<<info.b_left)&
        Hermes_Clear_x86.m_format->mask_b;

    Interface_x86->value=d_r|d_g|d_b;
  }

  Hermes_x86_Clearer(Interface_x86);
}

#endif
