#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Types.h"
#include "Clear_GC.h"
#include "HermConf.h"

BaseClear Hermes_Clear_GC=
{ 0,0,0,
  NULL,
  Hermes_Clear_GC_init,
  Hermes_Clear_GC_close,
  Hermes_Clear_GC_request,
  Hermes_Clear_GC_clear
};

// Clear function to use
static void (*Hermes_GC_Clear)(char8 *dest,int32 value,unsigned int width,
			       unsigned int height,int pitch);


void Hermes_Clear_GC_init()
{ Hermes_Clear_GC.m_format=(HermesFormat *)malloc(sizeof(HermesFormat));
}


void Hermes_Clear_GC_close()
{ if(Hermes_Clear_GC.m_format)
  { free(Hermes_Clear_GC.m_format);
    Hermes_Clear_GC.m_format=0;
  }
}


char Hermes_Clear_GC_request(HermesFormat *format)
{ char found=0;

  // Done that before
  if(HermesFormatEquals(format,Hermes_Clear_GC.m_format))
  return 1;

  Hermes_GC_Clear=0;

  switch(format->bpp)
  { case 32: Hermes_GC_Clear=Hermes_GC_Clear_32;
             found=1;
	     break;

    case 24: Hermes_GC_Clear=Hermes_GC_Clear_24;
             found=1;
	     break;

    case 16: Hermes_GC_Clear=Hermes_GC_Clear_16;
             found=1;
	     break;

     case 8: Hermes_GC_Clear=Hermes_GC_Clear_8;
             found=1;
	     break;
  }

  if(found)
  { HermesFormatCopy(format,Hermes_Clear_GC.m_format);
    printf("Hermes C surface clearer\n");

    return 1;
  }

  return 0;
}


void Hermes_Clear_GC_clear(void *pixels,int x1,int y1,int width,int height,
			   int pitch,int32 r,int32 g,int32 b,char8 index)
{ Hermes_Generic_Info info;
  int32 d_r,d_g,d_b,pixelval=0;
  char8 *dest;

  // No clear routine initialised
  if(!Hermes_GC_Clear) return;

  if(width<=0 || height<=0) return;

  // Generate real colour values
  if(Hermes_Clear_GC.m_format->indexed)
  { pixelval=index;
  }
  else
  { Hermes_Calculate_Generic_Info(24,16,8,Hermes_Clear_GC.m_format,
	  			  &info);
  
    pixelval=(r<<16)|(g<<8)|b;

    d_r=((pixelval>>info.r_right)<<info.r_left)&
        Hermes_Clear_GC.m_format->mask_r;
    d_g=((pixelval>>info.g_right)<<info.g_left)&
        Hermes_Clear_GC.m_format->mask_g;
    d_b=((pixelval>>info.b_right)<<info.b_left)&
        Hermes_Clear_GC.m_format->mask_b;

    pixelval=d_r|d_g|d_b;
  }
   
  dest=(char8 *)pixels;
  dest+=y1*pitch+x1*(Hermes_Clear_GC.m_format->bpp>>3);

  Hermes_GC_Clear(dest,pixelval,width,height,
		  pitch-width*(Hermes_Clear_GC.m_format->bpp>>3));
  
}


void Hermes_GC_Clear_32(char8 *dest,int32 value,unsigned int width,
  unsigned int height,int add)
{ unsigned int count;

  while(height--)
  { 
    count=width;
  
    while(count--)
    { *((int32 *)dest)=value;
      dest+=4;
    }

    dest+=add;
  }
}


void Hermes_GC_Clear_24(char8 *dest,int32 value,unsigned int width,
  unsigned int height,int add)
{ char8 *p_value=(char8 *)&value;
  unsigned int count;

  while(height--)
  { count=width;

    while(count--)
    { *(dest+R_24)=*(p_value+R_32);
      *(dest+G_24)=*(p_value+G_32);
      *(dest+B_24)=*(p_value+B_32);

      dest+=3;
    }

    dest+=add;
  }
}


void Hermes_GC_Clear_16(char8 *dest,int32 value,unsigned int width,
  unsigned int height,int add)
{ 
  int32 value32=(value<<16)|(value&0xffff);
  int countshifted;
  unsigned int count;

  while(height--)
  { count=width;
  
    // Align destination
    if((int)dest&0x3)
    { *((short16 *)dest)=(short16)value;
      dest+=2;
      count--;
    }

    countshifted=count>>1;

    while(countshifted--)
    { *((int32 *)dest)=value32;
      dest+=4;
    }

    if(count&1)
    { *((short16 *)dest)=(short16)value;
      dest+=2;
    }

    dest+=add;
  }
}


void Hermes_GC_Clear_8(char8 *dest,int32 value,unsigned int width,
  unsigned int height,int add)
{ unsigned int count,shiftcount;
  int32 value32;

  value=value&0xff; 
  value32=(value<<24)|(value<<16)|(value<<8)|value;

  while(height--)
  { count=width;
   
    while(((int)dest&0x3) && count)        // Align to dword boundary
    { *dest++=(char8)value;
      count--;
    }
    
    if(!count) break;
      
    shiftcount=count>>2;

    while(shiftcount--)
    { *((int32 *)dest)=value32;
      dest+=4;
    }

    count&=0x3;
    while(count--)
    *dest++=(char8)value;
    
    dest+=add;
  }
}
