//
// MMX surface clear implementation for the HERMES library
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions
//

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Hermes.h"
#include "ClearMMX.h"
#include "Head_MMX.h"


#ifndef NO_ASSEMBLER

static HermesClearInterface *Interface_MMX=0;

#ifdef __GNUC__
void (*Hermes_MMX_Clearer)(HermesClearInterface *) __attribute__ ((regparm(1)));
#else
void (*Hermes_MMX_Clearer)(HermesClearInterface *);
#endif

#ifdef __WATCOMC__
#pragma aux Hermes_MMX_Clearer parm [EAX] modify [EAX EBX ECX EDX ESI EDI]
#endif

void Hermes_Clear_MMX_init()
{ if(!Hermes_MMX_available) return;

  Hermes_Clear_MMX.m_format=(HermesFormat *)malloc(sizeof(HermesFormat));
  Interface_MMX=(HermesClearInterface *)malloc(sizeof(HermesClearInterface));
}


void Hermes_Clear_MMX_close()
{ if(!Hermes_MMX_available) return;

  if(Hermes_Clear_MMX.m_format)
  { free(Hermes_Clear_MMX.m_format);
    Hermes_Clear_MMX.m_format=0;
  }

  if(Interface_MMX)
  { free(Interface_MMX);
    Interface_MMX=0;
  }
}


char Hermes_Clear_MMX_request(HermesFormat *format)
{ char found=0;

  if(!Hermes_MMX_available) return 0;

  // Done that before
  if(HermesFormatEquals(format,Hermes_Clear_MMX.m_format))
  return 1;

  Hermes_MMX_Clearer=0;

  switch(format->bpp)
  { case 32: Hermes_MMX_Clearer=Clear32_MMX;
             found=1;
	     break;

    case 24: 
	     break;

    case 16: Hermes_MMX_Clearer=Clear16_MMX;
             found=1;
	     break;

     case 8: Hermes_MMX_Clearer=Clear8_MMX;
             found=1;
	     break;
  }

  if(found)
  { HermesFormatCopy(format,Hermes_Clear_MMX.m_format);
    printf("Hermes MMX Assembler Clearer\n");

    return 1;
  }

  return 0;
}


void Hermes_Clear_MMX_clear(void *pixels,int x1,int y1,int width,int height,
			   int pitch,int32 r,int32 g,int32 b,char8 index)
{ 
  Hermes_Generic_Info info;
  int32 d_r,d_g,d_b;

  // No clear routine initialised or invalid width / height
  if(!Hermes_MMX_Clearer) return;
  if(width<=0 || height<=0) return;


  Interface_MMX->dest=(char8 *)pixels;
  Interface_MMX->dest+=y1*pitch+x1*(Hermes_Clear_MMX.m_format->bpp>>3);

  Interface_MMX->width=width;
  Interface_MMX->height=height;
  Interface_MMX->add=pitch-width*(Hermes_Clear_MMX.m_format->bpp>>3);


  // Generate real colour values
  if(Hermes_Clear_MMX.m_format->indexed)
  { Interface_MMX->value=index;
  }
  else
  { Hermes_Calculate_Generic_Info(24,16,8,Hermes_Clear_MMX.m_format,
	  			  &info);
  
    Interface_MMX->value=(r<<16)|(g<<8)|b;

    d_r=((Interface_MMX->value>>info.r_right)<<info.r_left)&
        Hermes_Clear_MMX.m_format->mask_r;
    d_g=((Interface_MMX->value>>info.g_right)<<info.g_left)&
        Hermes_Clear_MMX.m_format->mask_g;
    d_b=((Interface_MMX->value>>info.b_right)<<info.b_left)&
        Hermes_Clear_MMX.m_format->mask_b;

    Interface_MMX->value=d_r|d_g|d_b;
  }

  Hermes_MMX_Clearer(Interface_MMX);
}

#endif
