//
// Main include file for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

#ifndef __PTC_H
#define __PTC_H



//
// OpenPTC signature define
// ------------------------
//
// This define is used to identify the OpenPTC library.
//
#define __PTC__


//
// Platform signature define
// -------------------------
//
// You must change the following #define to be a platform dependent
// signature define to identify your distribution.
//
// This define will be used by programmers to check what distribution
// of PTC they are running under and what extensions are available.
//
// Some examples of signature defines:
//
// #define __PTC_X11__        // X11 implementation
// #define __PTC_GGI__        // GGI implementation
// #define __PTC_DOS__        // DOS implementation
// #define __PTC_WIN32__      // Win32 implementation
// #define __PTC_SVGALIB__    // SVGALIB implementation
//
// The define must be in formatted as follows:
//
// #define __PTC_XXX__
//
// Where "XXX" is the PTC distribution name in uppercase.
//
#define __PTC_PORTING__


//
// OpenPTC version define
// ----------------------
//
// This define marks the version of the OpenPTC API that this
// implementation supports. Do not modify this define.
//
#define __PTC_VERSION__ "OpenPTC 1.0"


// integral types
#include "Types.h"

// public classes
#include "Key.h"
#include "Area.h"
#include "Base.h"
#include "Copy.h"
#include "Mode.h"
#include "Clear.h"
#include "Color.h"
#include "Error.h"
#include "Timer.h"
#include "Format.h"
#include "Clipper.h"
#include "Palette.h"
#include "Surface.h"
#include "Console.h"




#endif
