//
// Mode class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

#ifndef __PTC_MODE_H
#define __PTC_MODE_H

// include files
#include "Types.h"
#include "Format.h"




class Mode
{
    public:

        // setup
        Mode();
        Mode(int width,int height,const Format &format);
        Mode(const Mode &mode);
        ~Mode();

        // valid mode flag
        bool valid() const;

        // data access
        int width() const;
        int height() const;
        const Format& format() const;

        // operators
        Mode& operator =(const Mode &mode);
        bool operator ==(const Mode &mode) const;
        bool operator !=(const Mode &mode) const;

    private:

        // debug check
        void check() const;

        // data
        bool m_valid;
        int m_width;
        int m_height;
        Format m_format;
};




#endif
