//
// Format class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

#ifndef __PTC_FORMAT_H
#define __PTC_FORMAT_H

// include files
#include "Types.h"




class Format
{
    public:

        // setup
        Format();
        Format(int bits);
        Format(int bits,int32 r,int32 g,int32 b,int32 a=0);
        Format(const Format &format);
        ~Format();

        // data access
        int32 r() const;
        int32 g() const;
        int32 b() const;
        int32 a() const;
        int bits() const;
        int bytes() const;
        bool direct() const;
        bool indexed() const;

        // operators
        Format& operator =(const Format &format);
        bool operator ==(const Format &format) const;
        bool operator !=(const Format &format) const;

    private:

        // data
        int32 m_r;
        int32 m_g;
        int32 m_b;
        int32 m_a;
        int m_bits;
        bool m_direct;
        bool m_indexed;
};




#endif
