//
// Format class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// include files
#include "Error.h"
#include "Format.h"




Format::Format()
{
    // defaults
    m_bits = 0;
    m_r = 0;
    m_g = 0;
    m_b = 0;
    m_a = 0;
    m_direct = false;
    m_indexed = false;
}


Format::Format(int bits)
{
    // check bits per pixel
    if (bits!=8) throw Error("unsupported bits per pixel");

    // indexed color
    m_bits = bits;
    m_r = 0;
    m_g = 0;
    m_b = 0;
    m_a = 0;
    m_direct = false;
    m_indexed = true;
}


Format::Format(int bits,int32 r,int32 g,int32 b,int32 a)
{
    // check bits per pixel
    if (bits%8 || bits<=0 || bits>32) throw Error("unsupported bits per pixel");

    // direct color
    m_bits = bits;
    m_r = r;
    m_g = g;
    m_b = b;
    m_a = a;
    m_direct = true;
    m_indexed = false;
}


Format::Format(const Format &format)
{
    // copy constructor
    *this = format;
}


Format::~Format()
{
}




int32 Format::r() const
{
    // get r
    return m_r;
}


int32 Format::g() const
{
    // get g
    return m_g;
}


int32 Format::b() const
{
    // get b
    return m_b;
}


int32 Format::a() const
{
    // get a
    return m_a;
}


int Format::bits() const
{
    // get bits
    return m_bits;
}


int Format::bytes() const
{
    // get bits
    return m_bits/8;
}


bool Format::direct() const
{
    // get direct
    return m_direct;
}


bool Format::indexed() const
{
    // get indexed
    return m_indexed;
}




Format& Format::operator =(const Format &format)
{
    // check for self assignment
    if (this==&format) throw Error("self assignment is not allowed");
        
    // assignment
    m_bits = format.m_bits;
    m_r = format.m_r;
    m_g = format.m_g;
    m_b = format.m_b;
    m_a = format.m_a;
    m_direct = format.m_direct;
    m_indexed = format.m_indexed;
    return *this;
}


bool Format::operator ==(const Format &format) const
{
    // equal to
    if (m_direct && format.m_direct)
    {
        // direct color
        if (m_bits==format.m_bits && 
            m_r==format.m_r && 
            m_g==format.m_g && 
            m_b==format.m_b && 
            m_a==format.m_a) return true;
    }
    else if (m_indexed && format.m_indexed)
    {
        // indexed color
        if (m_bits==format.m_bits) return true;
    }

    // failure
    return false;
}


bool Format::operator !=(const Format &format) const
{
    // not equal to
    return !(*this==format);
}
