//
// Configuration header file for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

#ifndef __PTC_CONFIG_H
#define __PTC_CONFIG_H




//
// Debug build checking
// --------------------
//
// When __DEBUG__ is defined the OpenPTC implementation will
// perform runtime checking to trap bugs early. Because this 
// will greatly help with development of a new implementation 
// it enabled by default.
//
// When you release your implementation you should comment out
// the define below to increase performance. Alternatively you
// could provide a seperate debug and release library for your
// users and have __DEBUG__ defined only in the debug build.
//
#define __DEBUG__


//
// Boolean type support
// --------------------
//
// Some older compilers do not support the ANSI C++ 'bool' type.
//
// The OpenPTC 1.0 API depends on the bool type in many places.
// Without support for the bool type OpenPTC will not compile.
//
// On compilers that do not support the bool type you will have
// to comment out the define below so that the bool type gets
// emulated in 'Types.h'
//

// most compilers have bool support
#define __COMPILER_SUPPORTS_BOOL__




#endif
