//
// Color class for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

#ifndef __PTC_COLOR_H
#define __PTC_COLOR_H

// include files
#include "Types.h"




class Color
{
    public:

        // setup
        Color();
        Color(int index);
        Color(float r,float g,float b,float a=1.0f);
        Color(const Color &color);
        ~Color();

        // data access
        int index() const;
        float r() const;
        float g() const;
        float b() const;
        float a() const;
        bool direct() const;
        bool indexed() const;

        // operators
        Color& operator =(const Color &color);
        bool operator ==(const Color &color) const;
        bool operator !=(const Color &color) const;

    private:

        // data
        int m_index;
        float m_r;
        float m_g;
        float m_b;
        float m_a;
        bool m_direct;
        bool m_indexed;
};




#endif
