//
// Base classes for OpenPTC 1.0 C++ Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

#ifndef __PTC_BASE_H
#define __PTC_BASE_H

// include files
#include "Index.h"
#include "Types.h"




class BaseSurface
{
    public:

        // virtual destructor
        virtual ~BaseSurface() {};

        // copy to surface
        virtual void copy(BaseSurface &surface) = 0;
        virtual void copy(BaseSurface &surface,const Area &source,const Area &destination) = 0;

        // surface memory access
        virtual void* lock() = 0;
        virtual void unlock() = 0;

        // load pixels to surface
        virtual void load(const void *pixels,int width,int height,int pitch,const Format &format,const Palette &palette) = 0;
        virtual void load(const void *pixels,int width,int height,int pitch,const Format &format,const Palette &palette,const Area &source,const Area &destination) = 0;

        // save surface pixels
        virtual void save(void *pixels,int width,int height,int pitch,const Format &format,const Palette &palette) = 0;
        virtual void save(void *pixels,int width,int height,int pitch,const Format &format,const Palette &palette,const Area &source,const Area &destination) = 0;

        // clear surface
        virtual void clear() = 0;
        virtual void clear(const Color &color) = 0;
        virtual void clear(const Color &color,const Area &area) = 0;

        // surface palette
        virtual void palette(const Palette &palette) = 0;
        virtual const Palette& palette() const = 0;

        // surface clip area
        virtual void clip(const Area &area) = 0;

        // data access
        virtual int width() const = 0;
        virtual int height() const = 0;
        virtual int pitch() const = 0;
        virtual const Area& area() const = 0;
        virtual const Area& clip() const = 0;
        virtual const Format& format() const = 0;

        // surface option string
        virtual bool option(const char option[]) = 0;
};




class BaseConsole : public BaseSurface
{
    public:

        // virtual destructor
        virtual ~BaseConsole() {};

        // console configuration
        virtual void configure(const char file[]) = 0;

        // console modes
        virtual const Mode* modes() = 0;

        // console management
        virtual void open(const char title[],int pages = 0) = 0;
        virtual void open(const char title[],const Format &format,int pages = 0) = 0;
        virtual void open(const char title[],int width,int height,const Format &format,int pages = 0) = 0;
        virtual void open(const char title[],const Mode &mode,int pages = 0) = 0;
        virtual void close() = 0;

        // synchronization
        virtual void flush() = 0;
        virtual void finish() = 0;
        virtual void update() = 0;
        virtual void update(const Area &area) = 0;

        // keyboard input
        virtual bool key() = 0;
        virtual Key read() = 0;

        // data access
        virtual int pages() const = 0;
        virtual const char* name() const = 0;
        virtual const char* title() const = 0;
        virtual const char* information() const = 0;
};




#endif
