//
// Surface interface for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// package name
package ptc.base;

// import classes
import ptc.Area;
import ptc.Error;
import ptc.Color;
import ptc.Format;
import ptc.Palette;



public interface Surface
{
    // copy to surface
    public void copy(Surface surface) throws Error;
    public void copy(Surface surface,Area source,Area destination) throws Error;

    // surface memory access
    public Object lock() throws Error;
    public void unlock() throws Error;

    // load pixels to surface
    public void load(Object pixels,int width,int height,int pitch,Format format,Palette palette) throws Error;
    public void load(Object pixels,int width,int height,int pitch,Format format,Palette palette,Area source,Area destination) throws Error;

    // save surface pixels
    public void save(Object pixels,int width,int height,int pitch,Format format,Palette palette) throws Error;
    public void save(Object pixels,int width,int height,int pitch,Format format,Palette palette,Area source,Area destination) throws Error;

    // clear surface
    public void clear() throws Error;
    public void clear(Color color) throws Error;
    public void clear(Color color,Area area) throws Error;

    // surface palette
    public void palette(Palette palette) throws Error;
    public Palette palette() throws Error;

    // surface clip area
    public void clip(Area area) throws Error;

    // data access
    public int width() throws Error;
    public int height() throws Error;
    public int pitch() throws Error;
    public Area area() throws Error;
    public Area clip() throws Error;
    public Format format() throws Error;

    // surface option string
    public boolean option(String option) throws Error;
}
