//
// Key class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// package
package ptc;



public class Key implements Cloneable
{
    public Key()
    {
        // defaults
        code = UNDEFINED;
    }

    public Key(int code)
    {
        // setup data
        this.code = code;
        alt = false;
        shift = false;
        control = false;
    }

    public Key(int code,boolean alt,boolean shift,boolean control)
    {
        // setup data
        this.code = code;
        this.alt = alt;
        this.shift = shift;
        this.control = control;
    }

    public int code()
    {
        // get code
        return code;
    }

    public boolean alt()
    {
        // get alt
        return alt;
    }

    public boolean shift()
    {
        // get shift
        return shift;
    }

    public boolean control()
    {
        // get control
        return control;
    }

    public Key copy()
    {      
        try
        {
            // clone key object
            return (Key) clone();
        }
        catch (CloneNotSupportedException e)
        {
            // failure
            return null;
        }
    }
    
    public boolean compare(Key key)
    {
        // compare key data
        if (code==key.code && alt==key.alt && shift==key.shift && control==key.control) return true;
        else return false;
    }

    // key codes
    public static final int ENTER          = '\n';
    public static final int BACKSPACE      = '\b';
    public static final int TAB            = '\t';
    public static final int CANCEL         = 0x03;
    public static final int CLEAR          = 0x0C;
    public static final int SHIFT          = 0x10;
    public static final int CONTROL        = 0x11;
    public static final int ALT            = 0x12;
    public static final int PAUSE          = 0x13;
    public static final int CAPSLOCK       = 0x14;
    public static final int ESCAPE         = 0x1B;
    public static final int SPACE          = 0x20;
    public static final int PAGEUP         = 0x21;
    public static final int PAGEDOWN       = 0x22;
    public static final int END            = 0x23;
    public static final int HOME           = 0x24;
    public static final int LEFT           = 0x25;
    public static final int UP             = 0x26;
    public static final int RIGHT          = 0x27;
    public static final int DOWN           = 0x28;
    public static final int COMMA          = 0x2C;      // ','
    public static final int PERIOD         = 0x2E;      // '.'
    public static final int SLASH          = 0x2F;      // '/'
    public static final int ZERO           = 0x30;
    public static final int ONE            = 0x31;
    public static final int TWO            = 0x32;
    public static final int THREE          = 0x33;
    public static final int FOUR           = 0x34;
    public static final int FIVE           = 0x35;
    public static final int SIX            = 0x36;
    public static final int SEVEN          = 0x37;
    public static final int EIGHT          = 0x38;
    public static final int NINE           = 0x39;
    public static final int SEMICOLON      = 0x3B;      // ';'
    public static final int EQUALS         = 0x3D;      // '='
    public static final int A              = 0x41;
    public static final int B              = 0x42;
    public static final int C              = 0x43;
    public static final int D              = 0x44;
    public static final int E              = 0x45;
    public static final int F              = 0x46;
    public static final int G              = 0x47;
    public static final int H              = 0x48;
    public static final int I              = 0x49;
    public static final int J              = 0x4A;
    public static final int K              = 0x4B;
    public static final int L              = 0x4C;
    public static final int M              = 0x4D;
    public static final int N              = 0x4E;
    public static final int O              = 0x4F;
    public static final int P              = 0x50;
    public static final int Q              = 0x51;
    public static final int R              = 0x52;
    public static final int S              = 0x53;
    public static final int T              = 0x54;
    public static final int U              = 0x55;
    public static final int V              = 0x56;
    public static final int W              = 0x57;
    public static final int X              = 0x58;
    public static final int Y              = 0x59;
    public static final int Z              = 0x5A;
    public static final int OPENBRACKET    = 0x5B;      // '['
    public static final int BACKSLASH      = 0x5C;      // '\'
    public static final int CLOSEBRACKET   = 0x5D;      // ']'
    public static final int NUMPAD0        = 0x60;
    public static final int NUMPAD1        = 0x61;
    public static final int NUMPAD2        = 0x62;
    public static final int NUMPAD3        = 0x63;
    public static final int NUMPAD4        = 0x64;
    public static final int NUMPAD5        = 0x65;
    public static final int NUMPAD6        = 0x66;
    public static final int NUMPAD7        = 0x67;
    public static final int NUMPAD8        = 0x68;
    public static final int NUMPAD9        = 0x69;
    public static final int MULTIPLY       = 0x6A;      // numpad '*'
    public static final int ADD            = 0x6B;      // numpad '+'
    public static final int SEPARATOR      = 0x6C;
    public static final int SUBTRACT       = 0x6D;      // numpad '-'
    public static final int DECIMAL        = 0x6E;      // numpad '.'
    public static final int DIVIDE         = 0x6F;      // numpad '/'
    public static final int F1             = 0x70;
    public static final int F2             = 0x71;
    public static final int F3             = 0x72;
    public static final int F4             = 0x73;
    public static final int F5             = 0x74;
    public static final int F6             = 0x75;
    public static final int F7             = 0x76;
    public static final int F8             = 0x77;
    public static final int F9             = 0x78;
    public static final int F10            = 0x79;
    public static final int F11            = 0x7A;
    public static final int F12            = 0x7B;
    public static final int DELETE         = 0x7F;
    public static final int NUMLOCK        = 0x90;
    public static final int SCROLLLOCK     = 0x91;
    public static final int PRINTSCREEN    = 0x9A;
    public static final int INSERT         = 0x9B;
    public static final int HELP           = 0x9C;
    public static final int META           = 0x9D;
    public static final int BACKQUOTE      = 0xC0;
    public static final int QUOTE          = 0xDE;
    public static final int FINAL          = 0x18;      // asian keyboard
    public static final int CONVERT        = 0x1C;
    public static final int NONCONVERT     = 0x1D;
    public static final int ACCEPT         = 0x1E;
    public static final int MODECHANGE     = 0x1F;
    public static final int KANA           = 0x15;
    public static final int KANJI          = 0x19;
    public static final int UNDEFINED      = 0x00;      // undefined scan code

    // key data
    private int code;
    private boolean alt;
    private boolean shift;
    private boolean control;
}
