//
// Tunnel example for OpenPTC Java Implementation
// Copyright (c) Thomas Rizos (rizos@swipnet.se)
// This source code is licensed under the GNU GPL
// See http://www.gnu.org/copyleft/gpl.html for details
//

// import ptc
import ptc.Error;
import ptc.Timer;
import ptc.Format;
import ptc.Surface;


class Tunnel extends ptc.java.Applet
{
    public static void main(String args[])
    {
        try
        {
            // create format
            Format format = new Format(32,0x00FF0000,0x0000FF00,0x000000FF);

            // create console
            ptc.Console console = new ptc.Console();

            // open console
            console.open("Tunnel example",320,200,format);

            // create tunnel
            Tunnel tunnel = new Tunnel();

            // run tunnel demo
            tunnel.run(console);
        }
        catch (Error error)
        {
            // report error
            error.report();
        }

        // exit program
        System.exit(0);
    }

    public ptc.base.Console create() throws Error
    {
        // create format
        Format format = new Format(32,0x00FF0000,0x0000FF00,0x000000FF);

        // create console
        ptc.java.Console console = new ptc.java.Console();

        // open console on applet
        console.open(this,format);

        // return console
        return console;
    }

    public void run(ptc.base.Console console) throws Error
    {
        // create format
        Format format = new Format(32,0x00FF0000,0x0000FF00,0x000000FF);

        // create surface
        Surface surface = new Surface(320,200,format);
    
        // create tunnel
        Tunnel tunnel = new Tunnel();

        // create timer
        Timer timer = new Timer();

        // start timer
        timer.start();

        // loop until a key is pressed
        while (!console.key())
        {
            // get current time from timer
            final double time = timer.time();

            // lock surface
            int buffer[] = (int[]) surface.lock();

            // draw tunnel
            tunnel.draw(buffer,time);

            // unlock surface
            surface.unlock();

            // copy to console
            surface.copy(console);

            // update console
            console.update();
        }
    }

    Tunnel()
    {
        // allocate tables
        tunnel  = new int[64000];
        texture = new char[65536*2];

        // setup
        tunnel();
        texture();
    }

    void tunnel()
    {
        // tunnel index
        int index = 0;

        // generate tunnel table
        for (int y=100; y>-100; y--)
        {
            for (int x=-160; x<160; x++)
            {
                // calculate angle from center
                final double angle = Math.atan2(y,x) * 256 / pi / 2;
                
                // calculate radius from center
                final double radius = Math.sqrt(x*x + y*y);
                
                // texture coordinates
                final double u = angle;
                final double v = 6000/radius;
                
                // calculate texture index for (u,v)
                tunnel[index++] = ((int) v & 0xFF) * 256 + ((int) u & 0xFF);
            }
        }
    }

    void texture()
    {
        // array index
        int index = 0;

        // generate plasma texture
        float angle2 = pi * 2/256 * 230;
        for (int y=0; y<256*2; y++)
        {
            float angle1 = pi * 2/256 * 100;
            for (int x=0; x<256; x++)
            {
                texture[index++] = (char)( (float)(Math.sin(angle1)*80 + Math.sin(angle2)*40)+128);
                angle1 += pi*2/256*3;
            }
            angle2 += pi * 2 /256 *2;
        }
    }   

    void draw(int buffer[],double time)
    {
        // tunnel control functions
        int x = (int) ( Math.sin(time)*99.9 );
        int y = (int) ( time*200 );
                
        // calculate tunnel scroll offset
        int scroll = ((y&0xFF) << 8) + (x&0xFF);

        // loop through each pixel
        for (int i=0; i<64000; i++)
        {
            // lookup tunnel texture
            buffer[i] = texture[tunnel[i]+scroll];
        }
    }

    // tunnel data
    int tunnel[];
    char texture[];

    // useful pi constant
    static final float pi = 3.1415926f;
}
