//
// Main definition header for the HERMES library
// Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
// This source code is licensed under the GNU LGPL
//
// Please refer to the file COPYING.LIB contained in the distribution for
// licensing conditions
//

#ifndef __HERMES_COPY_H__
#define __HERMES_COPY_H__

#include "types.h"
#include "HermConf.h"

typedef struct {
  int32 bpp;
  int32 mask_r,mask_g,mask_b;
  char indexed;
} HermesFormat;

// Structure to hold shift amounts for the fallback routines (for really
// weird video modes that don't have a special routine)
typedef struct {
  int r_right,g_right,b_right;             // Shift amount to the right
  int r_left,g_left,b_left;                // Shift amount to the left
} Hermes_Generic_Info;

extern int32 *Hermes_Lookup;               // Lookup table for 8 bit conversion

// Initialise copying library
void HermesInit();

// De-initialise copying library
void HermesClose();

// Request a conversion. Returns non-zero if successful.
char HermesRequest(HermesFormat* source, HermesFormat* dest, char stretch);

// Set palette, the palette has to be size 256*4 (0RGB) and each colour
// component has to be 8 bit (not 6 bit, or something else)
void HermesPalette(int32 *palette);

// Do the actual copying. HermesRequest has to be called before this!
void HermesCopy(void *s_pixels,int s_x,int s_y,int s_width,int s_height,
	       int s_pitch,void *d_pixels,int d_x,int d_y,int d_width,
	       int d_height,int d_pitch);


// Utility routines for format structures

// Duplicate format (both format structures have to be allocated!)
void HermesFormatCopy(HermesFormat* source,HermesFormat *dest);

// Check if the two formats are equal
char HermesFormatEquals(HermesFormat* source,HermesFormat *dest);

// Find the top most bit that is set to 1 in mask
int Hermes_Topbit(int32 mask);

// Calculate left and right shifts for converter routines. s_r, s_g, s_b are
// the top bits set to one in the mask of the source colour components.
void Hermes_Calculate_Generic_Info(int32 s_r,int32 s_g,int32 s_b,
  HermesFormat *format,Hermes_Generic_Info *info);

#endif 
